package org.hyperscala.examples.ui

import org.hyperscala.web._
import org.hyperscala.ui.widgets._
import org.powerscala.{Country, Language}
import org.hyperscala.jquery.Gritter
import vs._
import org.hyperscala.examples.Example

/**
 * @author Matt Hicks <matt@outr.com>
 */
class VisualSearchExample extends Example {
  this.require(Gritter)

  val search = new VisualSearch {
    add(VisualSearchFacet.enum(Language, exactMatch = false))
    add(VisualSearchFacet.enum(Country))

    override def search(query: VisualSearchQuery) {
      super.search(query)

      Gritter.add(this.webpage, "Search", "Searched for: %s".format(query.query))
    }
  }
  contents += search
}