package org.hyperscala.event

import org.powerscala.enum.{Enumerated, EnumEntry}

/**
 * @author Matt Hicks <matt@outr.com>
 */
sealed class Key(val code: Int, val description: String) extends EnumEntry

object Key extends Enumerated[Key] {
  val Cancel = new Key(3, "Cancel key")
  val Help = new Key(6, "Help key")
  val BackSpace = new Key(8, "Backspace key")
  val Tab = new Key(9, "Tab key")
  val Clear = new Key(12, "'5' key on Numpad when NumLock is unlocked. Or on Mac, clear key which is positioned at NumLock key")
  val Return = new Key(13, "Return/enter key on the main keyboard")
  val Enter = new Key(14, "Reserved, but not used")
  val Shift = new Key(16, "Shift key")
  val Control = new Key(17, "Control key")
  val Alt = new Key(18, "Alt (Option on Mac) key")
  val Pause = new Key(19, "Pause key")
  val CapsLock = new Key(20, "Caps lock")
  val Escape = new Key(27, "Escape key")
  val Space = new Key(32, "Space bar")
  val PageUp = new Key(33, "Page Up key")
  val PageDown = new Key(34, "Page Down key")
  val End = new Key(35, "End key")
  val Home = new Key(36, "Home key")
  val Left = new Key(37, "Left arrow")
  val Up = new Key(38, "Up arrow")
  val Right = new Key(39, "Right arrow")
  val Down = new Key(40, "Down arrow")
  val Select = new Key(41, "Linux support for this keycode was added in Gecko 4.0")
  val Print = new Key(42, "Linux support for this keycode was added in Gecko 4.0")
  val Execute = new Key(43, "Linux support for this keycode was added in Gecko 4.0")
  val Printscreen = new Key(44, "Print Screen key")
  val Insert = new Key(45, "Ins(ert) key")
  val Delete = new Key(46, "Del(ete) key")
  val Zero = new Key(48, "")
  val One = new Key(49, "")
  val Two = new Key(50, "")
  val Three = new Key(51, "")
  val Four = new Key(52, "")
  val Five = new Key(53, "")
  val Six = new Key(54, "")
  val Seven = new Key(55, "")
  val Eight = new Key(56, "")
  val Nine = new Key(57, "")
  val Colon = new Key(58, "Colon (':') key. Requires Gecko 15.0")
  val Semicolon = new Key(59, "Semicolon (';') key")
  val LessThan = new Key(60, "Less-than ('<') key. Requires Gecko 15.0")
  val Equals = new Key(61, "Equals ('=') key")
  val GreaterThan = new Key(62, "Greater-than ('>') key. Requires Gecko 15.0")
  val QuestionMark = new Key(63, "Question mark ('?') key. Requires Gecko 15.0")
  val At = new Key(64, "Atmark ('@') key. Requires Gecko 15.0")
  val A = new Key(65, "")
  val B = new Key(66, "")
  val C = new Key(67, "")
  val D = new Key(68, "")
  val E = new Key(69, "")
  val F = new Key(70, "")
  val G = new Key(71, "")
  val H = new Key(72, "")
  val I = new Key(73, "")
  val J = new Key(74, "")
  val K = new Key(75, "")
  val L = new Key(76, "")
  val M = new Key(77, "")
  val N = new Key(78, "")
  val O = new Key(79, "")
  val P = new Key(80, "")
  val Q = new Key(81, "")
  val R = new Key(82, "")
  val S = new Key(83, "")
  val T = new Key(84, "")
  val U = new Key(85, "")
  val V = new Key(86, "")
  val W = new Key(87, "")
  val X = new Key(88, "")
  val Y = new Key(89, "")
  val Z = new Key(90, "")
  val ContextMenu = new Key(93, "")
  val Numpad0 = new Key(96, "0 on the numeric keypad")
  val Numpad1 = new Key(97, "1 on the numeric keypad")
  val Numpad2 = new Key(98, "2 on the numeric keypad")
  val Numpad3 = new Key(99, "3 on the numeric keypad")
  val Numpad4 = new Key(100, "4 on the numeric keypad")
  val Numpad5 = new Key(101, "5 on the numeric keypad")
  val Numpad6 = new Key(102, "6 on the numeric keypad")
  val Numpad7 = new Key(103, "7 on the numeric keypad")
  val Numpad8 = new Key(104, "8 on the numeric keypad")
  val Numpad9 = new Key(105, "9 on the numeric keypad")
  val Multiply = new Key(106, "* on the numeric keypad")
  val Add = new Key(107, "+ on the numeric keypad")
  val Separator = new Key(108, "")
  val Subtract = new Key(109, "- on the numeric keypad")
  val Decimal = new Key(110, "Decimal point on the numeric keypad")
  val Divide = new Key(111, "/ on the numeric keypad")
  val F1 = new Key(112, "F1 key")
  val F2 = new Key(113, "F2 key")
  val F3 = new Key(114, "F3 key")
  val F4 = new Key(115, "F4 key")
  val F5 = new Key(116, "F5 key")
  val F6 = new Key(117, "F6 key")
  val F7 = new Key(118, "F7 key")
  val F8 = new Key(119, "F8 key")
  val F9 = new Key(120, "F9 key")
  val F10 = new Key(121, "F10 key")
  val F11 = new Key(122, "F11 key")
  val F12 = new Key(123, "F12 key")
  val F13 = new Key(124, "F13 key")
  val F14 = new Key(125, "F14 key")
  val F15 = new Key(126, "F15 key")
  val F16 = new Key(127, "F16 key")
  val F17 = new Key(128, "F17 key")
  val F18 = new Key(129, "F18 key")
  val F19 = new Key(130, "F19 key")
  val F20 = new Key(131, "F20 key")
  val F21 = new Key(132, "F21 key")
  val F22 = new Key(133, "F22 key")
  val F23 = new Key(134, "F23 key")
  val F24 = new Key(135, "F24 key")
  val NumLock = new Key(144, "Num Lock key")
  val ScrollLock = new Key(145, "Scroll Lock key")
  val Circumflex = new Key(160, "Circumflex ('^') key. Requires Gecko 15.0")
  val Exclamation = new Key(161, "Exclamation ('!') key. Requires Gecko 15.0")
  val DoubleQuote = new Key(162, "Double quote (''') key. Requires Gecko 15.0")
  val Hash = new Key(163, "Hash ('#') key. Requires Gecko 15.0")
  val Dollar = new Key(164, "Dollar sign ('$') key. Requires Gecko 15.0")
  val Percent = new Key(165, "Percent ('%') key. Requires Gecko 15.0")
  val Ampersand = new Key(166, "Ampersand ('&') key. Requires Gecko 15.0")
  val Underscore = new Key(167, "Underscore ('_') key. Requires Gecko 15.0")
  val OpenParen = new Key(168, "Open parenthesis ('(') key. Requires Gecko 15.0")
  val CloseParen = new Key(169, "Close parenthesis (')') key. Requires Gecko 15.0")
  val Asterisk = new Key(170, "Asterisk ('*') key. Requires Gecko 15.0")
  val Plus = new Key(171, "Plus ('+') key. Requires Gecko 15.0")
  val Pipe = new Key(172, "Pipe ('|') key. Requires Gecko 15.0")
  val HyphenMinus = new Key(173, "Hyphen-US/docs/Minus ('-') key. Requires Gecko 15.0")
  val OpenCurlyBracket = new Key(174, "Open curly bracket ('{') key. Requires Gecko 15.0")
  val CloseCurlyBracket = new Key(175, "Close curly bracket ('}') key. Requires Gecko 15.0")
  val Tilde = new Key(176, "Tilde ('~') key. Requires Gecko 15.0")
  val Comma = new Key(188, "Comma (',') key")
  val Period = new Key(190, "Period ('.') key")
  val Slash = new Key(191, "Slash ('/') key")
  val BackQuote = new Key(192, "Back tick ('`') key")
  val OpenBracket = new Key(219, "Open square bracket ('[') key")
  val BackSlash = new Key(220, "Back slash ('\') key")
  val CloseBracket = new Key(221, "Close square bracket (']') key")
  val Quote = new Key(222, "Quote (''') key")
  val Meta = new Key(224, "Meta key on Linux, Command key on Mac")
  val Altgr = new Key(225, "AltGr key on Linux. Requires Gecko 15.0")
  val Win = new Key(91, "Windows logo key on Windows. Or Super or Hyper key on Linux. Requires Gecko 15.0")
  val Kana = new Key(21, "Linux support for this keycode was added in Gecko 4.0")
  val Hangul = new Key(21, "Linux support for this keycode was added in Gecko 4.0")
  val Eisu = new Key(22, "'英数' key on Japanese Mac keyboard. Requires Gecko 15.0")
  val Junja = new Key(23, "Linux support for this keycode was added in Gecko 4.0")
  val Final = new Key(24, "Linux support for this keycode was added in Gecko 4.0")
  val Hanja = new Key(25, "Linux support for this keycode was added in Gecko 4.0")
  val Kanji = new Key(25, "Linux support for this keycode was added in Gecko 4.0")
  val Convert = new Key(28, "Linux support for this keycode was added in Gecko 4.0")
  val Nonconvert = new Key(29, "Linux support for this keycode was added in Gecko 4.0")
  val Accept = new Key(30, "Linux support for this keycode was added in Gecko 4.0")
  val Modechange = new Key(31, "Linux support for this keycode was added in Gecko 4.0")
  val Sleep = new Key(95, "Linux support for this keycode was added in Gecko 4.0")

  def byCode(code: Int) = values.find(k => k.code == code)
}
