package org.hyperscala.event.processor

import org.hyperscala.event._
import org.powerscala.hierarchy.event.StandardHierarchyEventProcessor
import org.hyperscala.javascript.{JavaScriptContent, EventProperty}
import org.hyperscala.Markup
import org.powerscala.property.PropertyLike

/**
 * @author Matt Hicks <matt@outr.com>
 */
class JavaScriptEventProcessor[T <: JavaScriptEvent](name: String, markup: Markup)(implicit eventManifest: Manifest[T]) extends StandardHierarchyEventProcessor[T](name)(markup, eventManifest) with PropertyLike[JavaScriptContent] {
  val js = new EventProperty(name)(markup)

  def apply() = js()

  def apply(v1: JavaScriptContent) = js(v1)
}

class AfterPrintEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[AfterPrintEvent]("onafterprint", markup)
class BeforePrintEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[BeforePrintEvent]("onbeforeprint", markup)
class BeforeOnLoadEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[BeforeOnLoadEvent]("onbeforeonload", markup)
class HasChangeEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[HasChangeEvent]("onhaschange", markup)
class LoadEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[LoadEvent]("onload", markup)
class MessageEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[MessageEvent]("onmessage", markup)
class OfflineEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[OfflineEvent]("onoffline", markup)
class OnlineEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[OnlineEvent]("ononline", markup)
class PageHideEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[PageHideEvent]("onpagehide", markup)
class PageShowEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[PageShowEvent]("onpageshow", markup)
class PopStateEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[PopStateEvent]("onpopstate", markup)
class RedoEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[RedoEvent]("onredo", markup)
class ResizeEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[ResizeEvent]("onresize", markup)
class StorageEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[StorageEvent]("onstorage", markup)
class UndoEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[UndoEvent]("onundo", markup)
class UnLoadEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[UnLoadEvent]("onunload", markup)
class BlurEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[BlurEvent]("onblur", markup)
class ChangeEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[ChangeEvent]("onchange", markup)
class ContextMenuEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[ContextMenuEvent]("oncontextmenu", markup)
class FocusEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[FocusEvent]("onfocus", markup)
class FormChangeEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[FormChangeEvent]("onformchange", markup)
class FormInputEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[FormInputEvent]("onforminput", markup)
class InputEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[InputEvent]("oninput", markup)
class InvalidEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[InvalidEvent]("oninvalid", markup)
class ResetEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[ResetEvent]("onreset", markup)
class SelectEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[SelectEvent]("onselect", markup)
class SubmitEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[SubmitEvent]("onsubmit", markup)
class KeyDownEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[KeyDownEvent]("onkeydown", markup)
class KeyPressEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[KeyPressEvent]("onkeypress", markup)
class KeyUpEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[KeyUpEvent]("onkeyup", markup)
class ClickEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[ClickEvent]("onclick", markup)
class DoubleClickEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[DoubleClickEvent]("ondblclick", markup)
class DragEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[DragEvent]("ondrag", markup)
class DragEndEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[DragEndEvent]("ondragend", markup)
class DragEnterEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[DragEnterEvent]("ondragenter", markup)
class DragLeaveEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[DragLeaveEvent]("ondragleave", markup)
class DragOverEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[DragOverEvent]("ondragover", markup)
class DragStartEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[DragStartEvent]("ondragstart", markup)
class DropEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[DropEvent]("ondrop", markup)
class MouseDownEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[MouseDownEvent]("onmousedown", markup)
class MouseMoveEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[MouseMoveEvent]("onmousemove", markup)
class MouseOutEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[MouseOutEvent]("onmouseout", markup)
class MouseOverEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[MouseOverEvent]("onmouseover", markup)
class MouseUpEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[MouseUpEvent]("onmouseup", markup)
class MouseWheelEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[MouseWheelEvent]("onmousewheel", markup)
class ScrollEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[ScrollEvent]("onscroll", markup)
class AbortEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[AbortEvent]("onabort", markup)
class CanPlayEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[CanPlayEvent]("oncanplay", markup)
class CanPlayThroughEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[CanPlayThroughEvent]("oncanplaythrough", markup)
class DurationChangeEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[DurationChangeEvent]("ondurationchange", markup)
class EmptiedEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[EmptiedEvent]("onemptied", markup)
class EndedEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[EndedEvent]("onended", markup)
class ErrorEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[ErrorEvent]("onerror", markup)
class LoadedDataEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[LoadedDataEvent]("onloadeddata", markup)
class LoadedMetaDataEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[LoadedMetaDataEvent]("onloadedmetadata", markup)
class LoadStartEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[LoadStartEvent]("onloadstart", markup)
class PauseEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[PauseEvent]("onpause", markup)
class PlayEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[PlayEvent]("onplay", markup)
class PlayingEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[PlayingEvent]("onplaying", markup)
class ProgressEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[ProgressEvent]("onprogress", markup)
class RateChangeEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[RateChangeEvent]("onratechange", markup)
class ReadyStateChangeEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[ReadyStateChangeEvent]("onreadystatechange", markup)
class SeekedEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[SeekedEvent]("onseeked", markup)
class SeekingEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[SeekingEvent]("onseeking", markup)
class StalledEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[StalledEvent]("onstalled", markup)
class SuspendEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[SuspendEvent]("onsuspend", markup)
class TimeUpdateEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[TimeUpdateEvent]("ontimeupdate", markup)
class VolumeChangeEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[VolumeChangeEvent]("onvolumechange", markup)
class WaitingEventProcessor(implicit markup: Markup) extends JavaScriptEventProcessor[WaitingEvent]("onwaiting", markup)
