/*
 * Decompiled with CFR 0.152.
 */
package org.hyperscala.selector;

import org.hyperscala.html.HTMLTag;
import org.hyperscala.html.HTMLTagType;
import org.hyperscala.html.HTMLTagType$;
import org.hyperscala.persistence.ValuePersistence;
import org.hyperscala.selector.AllSelector;
import org.hyperscala.selector.AllSelector$;
import org.hyperscala.selector.AttributeExistsSelector;
import org.hyperscala.selector.AttributeMatcher;
import org.hyperscala.selector.AttributeSelector;
import org.hyperscala.selector.ChildSelector;
import org.hyperscala.selector.ClassSelector;
import org.hyperscala.selector.DescendantSelector;
import org.hyperscala.selector.ElementSelector;
import org.hyperscala.selector.ElementSelector$;
import org.hyperscala.selector.IdSelector;
import org.hyperscala.selector.IdSelector$;
import org.hyperscala.selector.MultipleSelector;
import org.hyperscala.selector.PrecedingSelector;
import org.hyperscala.selector.PseudoClass;
import org.hyperscala.selector.PseudoClass$;
import org.hyperscala.selector.PseudoClassSelector;
import org.hyperscala.selector.Selector;
import org.hyperscala.selector.TagIdSelector;
import org.hyperscala.selector.TagIdSelector$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class Selector$
implements ValuePersistence<List<Selector>> {
    public static final Selector$ MODULE$;
    private AllSelector all;
    private final Regex AllSelectorRegex;
    private final Regex ClassSelectorRegex;
    private final Regex ElementSelectorRegex;
    private final Regex IdSelectorRegex;
    private final Regex ChildSelectorRegex;
    private final Regex PseudoSelectorRegex;
    private final Regex PrecedingSelectorRegex;
    private final Regex DescendantSelectorRegex;
    private final Regex AttributeValueSelectorRegex;
    private final Regex AttributeExistsSelectorRegex;
    private final Regex MultipleSelectorRegex;
    private volatile boolean bitmap$0;

    static {
        new Selector$();
    }

    private AllSelector all$lzycompute() {
        Selector$ selector$ = this;
        synchronized (selector$) {
            if (!this.bitmap$0) {
                this.all = new AllSelector(AllSelector$.MODULE$.apply$default$1());
                this.bitmap$0 = true;
            }
            return this.all;
        }
    }

    public AllSelector all() {
        return this.bitmap$0 ? this.all : this.all$lzycompute();
    }

    public ClassSelector clazz(String className, Option<Selector> parent) {
        return new ClassSelector(className, parent);
    }

    public Option<Selector> clazz$default$2() {
        return None$.MODULE$;
    }

    public <T extends HTMLTag> ElementSelector<T> element(Manifest<T> manifest) {
        return new ElementSelector((HTMLTagType)((Object)HTMLTagType$.MODULE$.byClass(manifest.runtimeClass()).get()), ElementSelector$.MODULE$.apply$default$2());
    }

    public PseudoClassSelector pseudo(PseudoClass clazz, Option<Selector> parent) {
        return new PseudoClassSelector(clazz, parent);
    }

    public Option<Selector> pseudo$default$2() {
        return None$.MODULE$;
    }

    public AttributeExistsSelector attribute(String attribute, Option<Selector> parent) {
        return new AttributeExistsSelector(attribute, parent);
    }

    public AttributeSelector attribute(String attribute, AttributeMatcher matcher, String attributeValue, Option<Selector> parent) {
        return new AttributeSelector(attribute, matcher, attributeValue, parent);
    }

    public IdSelector id(String id) {
        return new IdSelector(id, IdSelector$.MODULE$.apply$default$2());
    }

    public TagIdSelector id(HTMLTag t) {
        return new TagIdSelector(t, TagIdSelector$.MODULE$.apply$default$2());
    }

    public Selector multiple(Seq<Selector> selectors) {
        ObjectRef current = ObjectRef.create((Object)((Selector)selectors.head()));
        ((IterableLike)selectors.tail()).foreach((Function1)new Serializable(current){
            private final ObjectRef current$1;

            public final void apply(Selector x0$1) {
                Selector selector = x0$1;
                MultipleSelector multiple2 = new MultipleSelector((Option<Selector>)new Some((Object)((Selector)this.current$1.elem)));
                this.current$1.elem = selector.addRoot(multiple2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.current$1 = current$1;
            }
        });
        return (Selector)current.elem;
    }

    public Nothing$ fromString(String s, String name, Class<?> clazz) {
        throw new UnsupportedOperationException("Not supported");
    }

    public String toString(List<Selector> t, String name, Class<?> clazz) {
        return ((TraversableOnce)t.map((Function1)new Serializable(){

            public final String apply(Selector sss) {
                return sss.value();
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private Regex AllSelectorRegex() {
        return this.AllSelectorRegex;
    }

    private Regex ClassSelectorRegex() {
        return this.ClassSelectorRegex;
    }

    private Regex ElementSelectorRegex() {
        return this.ElementSelectorRegex;
    }

    private Regex IdSelectorRegex() {
        return this.IdSelectorRegex;
    }

    private Regex ChildSelectorRegex() {
        return this.ChildSelectorRegex;
    }

    private Regex PseudoSelectorRegex() {
        return this.PseudoSelectorRegex;
    }

    private Regex PrecedingSelectorRegex() {
        return this.PrecedingSelectorRegex;
    }

    private Regex DescendantSelectorRegex() {
        return this.DescendantSelectorRegex;
    }

    private Regex AttributeValueSelectorRegex() {
        return this.AttributeValueSelectorRegex;
    }

    private Regex AttributeExistsSelectorRegex() {
        return this.AttributeExistsSelectorRegex;
    }

    private Regex MultipleSelectorRegex() {
        return this.MultipleSelectorRegex;
    }

    public final Selector apply(String selectorString, Option<Selector> parent) {
        String string;
        while (true) {
            boolean bl;
            if (bl = (string = selectorString) == null ? true : "".equals(string)) {
                Selector selector = (Selector)parent.getOrElse((Function0)new Serializable(selectorString){
                    private final String selectorString$1;

                    public final Nothing$ apply() {
                        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse selector from: [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.selectorString$1})));
                    }
                    {
                        this.selectorString$1 = selectorString$1;
                    }
                });
                return selector;
            }
            Option option = this.AllSelectorRegex().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String extra = (String)((LinearSeqOptimized)option.get()).apply(0);
                parent = new Some((Object)new AllSelector((Option<Selector>)parent));
                selectorString = extra;
                continue;
            }
            Option option2 = this.ClassSelectorRegex().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                String className = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String extra = (String)((LinearSeqOptimized)option2.get()).apply(1);
                parent = new Some((Object)new ClassSelector(className, (Option<Selector>)parent));
                selectorString = extra;
                continue;
            }
            Option option3 = this.IdSelectorRegex().unapplySeq((CharSequence)string);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                String id = (String)((LinearSeqOptimized)option3.get()).apply(0);
                String extra = (String)((LinearSeqOptimized)option3.get()).apply(1);
                parent = new Some((Object)new IdSelector(id, (Option<Selector>)parent));
                selectorString = extra;
                continue;
            }
            Option option4 = this.ElementSelectorRegex().unapplySeq((CharSequence)string);
            if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(2) == 0) {
                String element = (String)((LinearSeqOptimized)option4.get()).apply(0);
                String extra = (String)((LinearSeqOptimized)option4.get()).apply(1);
                parent = new Some(new ElementSelector((HTMLTagType)((Object)HTMLTagType$.MODULE$.get(element).getOrElse((Function0)new Serializable(element){
                    private final String element$1;

                    public final Nothing$ apply() {
                        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find tag type from: [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.element$1})));
                    }
                    {
                        this.element$1 = element$1;
                    }
                })), (Option<Selector>)parent));
                selectorString = extra;
                continue;
            }
            Option option5 = this.ChildSelectorRegex().unapplySeq((CharSequence)string);
            if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(1) == 0) {
                String extra = (String)((LinearSeqOptimized)option5.get()).apply(0);
                parent = new Some((Object)new ChildSelector((Option<Selector>)parent));
                selectorString = extra;
                continue;
            }
            Option option6 = this.PseudoSelectorRegex().unapplySeq((CharSequence)string);
            if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(2) == 0) {
                String pseudo = (String)((LinearSeqOptimized)option6.get()).apply(0);
                String extra = (String)((LinearSeqOptimized)option6.get()).apply(1);
                parent = new Some((Object)new PseudoClassSelector((PseudoClass)PseudoClass$.MODULE$.apply(pseudo), (Option<Selector>)parent));
                selectorString = extra;
                continue;
            }
            Option option7 = this.PrecedingSelectorRegex().unapplySeq((CharSequence)string);
            if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(1) == 0) {
                String extra = (String)((LinearSeqOptimized)option7.get()).apply(0);
                parent = new Some((Object)new PrecedingSelector((Option<Selector>)parent));
                selectorString = extra;
                continue;
            }
            Option option8 = this.DescendantSelectorRegex().unapplySeq((CharSequence)string);
            if (!option8.isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(1) == 0) {
                String extra = (String)((LinearSeqOptimized)option8.get()).apply(0);
                parent = new Some((Object)new DescendantSelector((Option<Selector>)parent));
                selectorString = extra;
                continue;
            }
            Option option9 = this.AttributeValueSelectorRegex().unapplySeq((CharSequence)string);
            if (!option9.isEmpty() && option9.get() != null && ((LinearSeqOptimized)option9.get()).lengthCompare(4) == 0) {
                String attribute = (String)((LinearSeqOptimized)option9.get()).apply(0);
                String matcher = (String)((LinearSeqOptimized)option9.get()).apply(1);
                String value = (String)((LinearSeqOptimized)option9.get()).apply(2);
                String extra = (String)((LinearSeqOptimized)option9.get()).apply(3);
                parent = new Some((Object)new AttributeSelector(attribute, new AttributeMatcher(matcher), value, (Option<Selector>)parent));
                selectorString = extra;
                continue;
            }
            Option option10 = this.AttributeExistsSelectorRegex().unapplySeq((CharSequence)string);
            if (!option10.isEmpty() && option10.get() != null && ((LinearSeqOptimized)option10.get()).lengthCompare(2) == 0) {
                String attribute = (String)((LinearSeqOptimized)option10.get()).apply(0);
                String extra = (String)((LinearSeqOptimized)option10.get()).apply(1);
                parent = new Some((Object)new AttributeExistsSelector(attribute, (Option<Selector>)parent));
                selectorString = extra;
                continue;
            }
            Option option11 = this.MultipleSelectorRegex().unapplySeq((CharSequence)string);
            if (option11.isEmpty() || option11.get() == null || ((LinearSeqOptimized)option11.get()).lengthCompare(1) != 0) break;
            String extra = (String)((LinearSeqOptimized)option11.get()).apply(0);
            parent = new Some((Object)new MultipleSelector((Option<Selector>)parent));
            selectorString = extra;
        }
        throw new MatchError((Object)string);
    }

    public final Option<Selector> apply$default$2() {
        return None$.MODULE$;
    }

    public Option<Selector> get(String selectorString) {
        return selectorString != null && new StringOps(Predef$.MODULE$.augmentString(selectorString.trim())).nonEmpty() ? new Some((Object)this.apply(selectorString, this.apply$default$2())) : None$.MODULE$;
    }

    private Selector$() {
        MODULE$ = this;
        this.AllSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[*](.*)")).r();
        this.ClassSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[.]([a-zA-Z0-9-_]*)(.*)")).r();
        this.ElementSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z0-9-]+)(.*)")).r();
        this.IdSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[#]([a-zA-Z0-9-]*)(.*)")).r();
        this.ChildSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[ ]?[>][ ]?(.*)")).r();
        this.PseudoSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[ ]?[:][ ]?([a-zA-Z0-9-]*)(.*)")).r();
        this.PrecedingSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[ ]*[+][ ]*(.*)")).r();
        this.DescendantSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[ ](.*)")).r();
        this.AttributeValueSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("\\[(\\S*?)(=|~=|\\|=)\\\"(.+)\\\"\\](.*)")).r();
        this.AttributeExistsSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("\\[(\\S*?)\\](.*)")).r();
        this.MultipleSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[ ]?,[ ]?(.*)")).r();
    }
}

