/*
 * Decompiled with CFR 0.152.
 */
package org.hyperscala.selector;

import org.hyperscala.IdentifiableTag;
import org.hyperscala.html.HTMLTag;
import org.hyperscala.html.HTMLTagType;
import org.hyperscala.html.HTMLTagType$;
import org.hyperscala.persistence.ValuePersistence;
import org.hyperscala.selector.AllSelector;
import org.hyperscala.selector.AllSelector$;
import org.hyperscala.selector.AttributeExistsSelector;
import org.hyperscala.selector.AttributeMatcher;
import org.hyperscala.selector.AttributeSelector;
import org.hyperscala.selector.ChildSelector;
import org.hyperscala.selector.ClassSelector;
import org.hyperscala.selector.DescendantSelector;
import org.hyperscala.selector.ElementSelector;
import org.hyperscala.selector.ElementSelector$;
import org.hyperscala.selector.IdSelector;
import org.hyperscala.selector.IdSelector$;
import org.hyperscala.selector.MultipleSelector;
import org.hyperscala.selector.PrecedingSelector;
import org.hyperscala.selector.PseudoClass;
import org.hyperscala.selector.PseudoClass$;
import org.hyperscala.selector.PseudoClassSelector;
import org.hyperscala.selector.Selector;
import org.hyperscala.selector.TagIdSelector;
import org.hyperscala.selector.TagIdSelector$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.Manifest;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class Selector$
implements ValuePersistence<List<Selector>> {
    public static final Selector$ MODULE$;
    private AllSelector all;
    private final Regex AllSelectorRegex;
    private final Regex ClassSelectorRegex;
    private final Regex ElementSelectorRegex;
    private final Regex IdSelectorRegex;
    private final Regex ChildSelectorRegex;
    private final Regex PseudoSelectorRegex;
    private final Regex PrecedingSelectorRegex;
    private final Regex DescendantSelectorRegex;
    private final Regex AttributeValueSelectorRegex;
    private final Regex AttributeExistsSelectorRegex;
    private final Regex MultipleSelectorRegex;
    private volatile boolean bitmap$0;

    static {
        new Selector$();
    }

    private AllSelector all$lzycompute() {
        Selector$ selector$ = this;
        synchronized (selector$) {
            if (!this.bitmap$0) {
                this.all = new AllSelector(AllSelector$.MODULE$.apply$default$1());
                this.bitmap$0 = true;
            }
            return this.all;
        }
    }

    public AllSelector all() {
        return this.bitmap$0 ? this.all : this.all$lzycompute();
    }

    public ClassSelector clazz(String className, Option<Selector> parent) {
        return new ClassSelector(className, parent);
    }

    public Option<Selector> clazz$default$2() {
        return None$.MODULE$;
    }

    public <T extends HTMLTag> ElementSelector<T> element(Manifest<T> manifest) {
        return new ElementSelector((HTMLTagType)HTMLTagType$.MODULE$.byClass(manifest.runtimeClass()).get(), ElementSelector$.MODULE$.apply$default$2());
    }

    public PseudoClassSelector pseudo(PseudoClass clazz2, Option<Selector> parent) {
        return new PseudoClassSelector(clazz2, parent);
    }

    public Option<Selector> pseudo$default$2() {
        return None$.MODULE$;
    }

    public AttributeExistsSelector attribute(String attribute, Option<Selector> parent) {
        return new AttributeExistsSelector(attribute, parent);
    }

    public AttributeSelector attribute(String attribute, AttributeMatcher matcher, String attributeValue, Option<Selector> parent) {
        return new AttributeSelector(attribute, matcher, attributeValue, parent);
    }

    public IdSelector id(String id) {
        return new IdSelector(id, IdSelector$.MODULE$.apply$default$2());
    }

    public TagIdSelector id(HTMLTag t) {
        return new TagIdSelector((IdentifiableTag)t, TagIdSelector$.MODULE$.apply$default$2());
    }

    public Selector multiple(Seq<Selector> selectors) {
        ObjectRef current = new ObjectRef((Object)((Selector)selectors.head()));
        ((IterableLike)selectors.tail()).foreach((Function1)new /* Unavailable Anonymous Inner Class!! */);
        return (Selector)current.elem;
    }

    public Nothing$ fromString(String s, String name2, Class<?> clazz2) {
        throw new UnsupportedOperationException("Not supported");
    }

    public String toString(List<Selector> t, String name2, Class<?> clazz2) {
        return ((TraversableOnce)t.map((Function1)new /* Unavailable Anonymous Inner Class!! */, List$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private Regex AllSelectorRegex() {
        return this.AllSelectorRegex;
    }

    private Regex ClassSelectorRegex() {
        return this.ClassSelectorRegex;
    }

    private Regex ElementSelectorRegex() {
        return this.ElementSelectorRegex;
    }

    private Regex IdSelectorRegex() {
        return this.IdSelectorRegex;
    }

    private Regex ChildSelectorRegex() {
        return this.ChildSelectorRegex;
    }

    private Regex PseudoSelectorRegex() {
        return this.PseudoSelectorRegex;
    }

    private Regex PrecedingSelectorRegex() {
        return this.PrecedingSelectorRegex;
    }

    private Regex DescendantSelectorRegex() {
        return this.DescendantSelectorRegex;
    }

    private Regex AttributeValueSelectorRegex() {
        return this.AttributeValueSelectorRegex;
    }

    private Regex AttributeExistsSelectorRegex() {
        return this.AttributeExistsSelectorRegex;
    }

    private Regex MultipleSelectorRegex() {
        return this.MultipleSelectorRegex;
    }

    public final Selector apply(String selectorString, Option<Selector> parent) {
        String string;
        while (true) {
            boolean bl;
            if ((string = selectorString) == null) {
                bl = true;
            } else {
                String string2 = string;
                bl = !("" != null ? !"".equals(string2) : string2 != null);
            }
            if (bl) {
                Selector selector = (Selector)parent.getOrElse((Function0)new /* Unavailable Anonymous Inner Class!! */);
                return selector;
            }
            Option option2 = this.AllSelectorRegex().unapplySeq((Object)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String extra = (String)((LinearSeqOptimized)option2.get()).apply(0);
                parent = new Some((Object)new AllSelector(parent));
                selectorString = extra;
                continue;
            }
            Option option3 = this.ClassSelectorRegex().unapplySeq((Object)string);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                String className = (String)((LinearSeqOptimized)option3.get()).apply(0);
                String extra = (String)((LinearSeqOptimized)option3.get()).apply(1);
                parent = new Some((Object)new ClassSelector(className, (Option)parent));
                selectorString = extra;
                continue;
            }
            Option option4 = this.IdSelectorRegex().unapplySeq((Object)string);
            if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(2) == 0) {
                String id = (String)((LinearSeqOptimized)option4.get()).apply(0);
                String extra = (String)((LinearSeqOptimized)option4.get()).apply(1);
                parent = new Some((Object)new IdSelector(id, (Option)parent));
                selectorString = extra;
                continue;
            }
            Option option5 = this.ElementSelectorRegex().unapplySeq((Object)string);
            if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(2) == 0) {
                String element = (String)((LinearSeqOptimized)option5.get()).apply(0);
                String extra = (String)((LinearSeqOptimized)option5.get()).apply(1);
                parent = new Some((Object)new ElementSelector((HTMLTagType)HTMLTagType$.MODULE$.get(element).getOrElse((Function0)new /* Unavailable Anonymous Inner Class!! */), (Option)parent));
                selectorString = extra;
                continue;
            }
            Option option6 = this.ChildSelectorRegex().unapplySeq((Object)string);
            if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(1) == 0) {
                String extra = (String)((LinearSeqOptimized)option6.get()).apply(0);
                parent = new Some((Object)new ChildSelector((Option)parent));
                selectorString = extra;
                continue;
            }
            Option option7 = this.PseudoSelectorRegex().unapplySeq((Object)string);
            if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(2) == 0) {
                String pseudo = (String)((LinearSeqOptimized)option7.get()).apply(0);
                String extra = (String)((LinearSeqOptimized)option7.get()).apply(1);
                parent = new Some((Object)new PseudoClassSelector((PseudoClass)PseudoClass$.MODULE$.apply(pseudo), (Option)parent));
                selectorString = extra;
                continue;
            }
            Option option8 = this.PrecedingSelectorRegex().unapplySeq((Object)string);
            if (!option8.isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(1) == 0) {
                String extra = (String)((LinearSeqOptimized)option8.get()).apply(0);
                parent = new Some((Object)new PrecedingSelector((Option)parent));
                selectorString = extra;
                continue;
            }
            Option option9 = this.DescendantSelectorRegex().unapplySeq((Object)string);
            if (!option9.isEmpty() && option9.get() != null && ((LinearSeqOptimized)option9.get()).lengthCompare(1) == 0) {
                String extra = (String)((LinearSeqOptimized)option9.get()).apply(0);
                parent = new Some((Object)new DescendantSelector((Option)parent));
                selectorString = extra;
                continue;
            }
            Option option10 = this.AttributeValueSelectorRegex().unapplySeq((Object)string);
            if (!option10.isEmpty() && option10.get() != null && ((LinearSeqOptimized)option10.get()).lengthCompare(4) == 0) {
                String attribute = (String)((LinearSeqOptimized)option10.get()).apply(0);
                String matcher = (String)((LinearSeqOptimized)option10.get()).apply(1);
                String value = (String)((LinearSeqOptimized)option10.get()).apply(2);
                String extra = (String)((LinearSeqOptimized)option10.get()).apply(3);
                parent = new Some((Object)new AttributeSelector(attribute, new AttributeMatcher(matcher), value, (Option)parent));
                selectorString = extra;
                continue;
            }
            Option option11 = this.AttributeExistsSelectorRegex().unapplySeq((Object)string);
            if (!option11.isEmpty() && option11.get() != null && ((LinearSeqOptimized)option11.get()).lengthCompare(2) == 0) {
                String attribute = (String)((LinearSeqOptimized)option11.get()).apply(0);
                String extra = (String)((LinearSeqOptimized)option11.get()).apply(1);
                parent = new Some((Object)new AttributeExistsSelector(attribute, (Option)parent));
                selectorString = extra;
                continue;
            }
            Option option12 = this.MultipleSelectorRegex().unapplySeq((Object)string);
            if (option12.isEmpty() || option12.get() == null || ((LinearSeqOptimized)option12.get()).lengthCompare(1) != 0) break;
            String extra = (String)((LinearSeqOptimized)option12.get()).apply(0);
            parent = new Some((Object)new MultipleSelector((Option)parent));
            selectorString = extra;
        }
        throw new MatchError((Object)string);
    }

    public final Option<Selector> apply$default$2() {
        return None$.MODULE$;
    }

    public Option<Selector> get(String selectorString) {
        return selectorString != null && new StringOps(Predef$.MODULE$.augmentString(selectorString.trim())).nonEmpty() ? new Some((Object)this.apply(selectorString, this.apply$default$2())) : None$.MODULE$;
    }

    private Selector$() {
        MODULE$ = this;
        this.AllSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[*](.*)")).r();
        this.ClassSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[.]([a-zA-Z0-9-_]*)(.*)")).r();
        this.ElementSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z0-9-]+)(.*)")).r();
        this.IdSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[#]([a-zA-Z0-9-]*)(.*)")).r();
        this.ChildSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[ ]?[>][ ]?(.*)")).r();
        this.PseudoSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[ ]?[:][ ]?([a-zA-Z0-9-]*)(.*)")).r();
        this.PrecedingSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[ ]*[+][ ]*(.*)")).r();
        this.DescendantSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[ ](.*)")).r();
        this.AttributeValueSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("\\[(\\S*?)(=|~=|\\|=)\\\"(.+)\\\"\\](.*)")).r();
        this.AttributeExistsSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("\\[(\\S*?)\\](.*)")).r();
        this.MultipleSelectorRegex = new StringOps(Predef$.MODULE$.augmentString("[ ]?,[ ]?(.*)")).r();
    }
}

