/**
 * Class Applier module for Rangy.
 * Adds, removes and toggles classes on Ranges and Selections
 *
 * Part of Rangy, a cross-browser JavaScript range and selection library
 * https://github.com/timdown/rangy
 *
 * Depends on Rangy core.
 *
 * Copyright 2015, Tim Down
 * Licensed under the MIT license.
 * Version: 1.3.0-alpha.20150122
 * Build date: 22 January 2015
 */
!function(e,t){"function"==typeof define&&define.amd?define(["./rangy-core"],e):"undefined"!=typeof module&&"object"==typeof exports?module.exports=e(require("rangy")):e(t.rangy)}(function(e){e.createModule("ClassApplier",["WrappedSelection"],function(e,t){function n(e,t){for(var n in e)if(e.hasOwnProperty(n)&&t(n,e[n])===!1)return!1;return!0}function s(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")}function i(e){return e&&e.split(/\s+/).sort().join(" ")}function r(e){return i(e.className)}function o(e,t){return r(e)==r(t)}function a(e,t,n,s,i){var r=e.node,o=e.offset,a=r,l=o;r==s&&o>i&&++l,r!=t||o!=n&&o!=n+1||(a=s,l+=i-n),r==t&&o>n+1&&--l,e.node=a,e.offset=l}function l(e,t,n){e.node==t&&e.offset>n&&--e.offset}function f(e,t,n,s){-1==n&&(n=t.childNodes.length);for(var i,r=e.parentNode,o=L.getNodeIndex(e),l=0;i=s[l++];)a(i,r,o,t,n);t.childNodes.length==n?t.appendChild(e):t.insertBefore(e,t.childNodes[n])}function u(e,t){for(var n,s=e.parentNode,i=L.getNodeIndex(e),r=0;n=t[r++];)l(n,s,i);e.parentNode.removeChild(e)}function d(e,t,n,s,i){for(var r,o=[];r=e.firstChild;)f(r,t,n++,i),o.push(r);return s&&u(e,i),o}function p(e,t){return d(e,e.parentNode,L.getNodeIndex(e),!0,t)}function c(e,t){var n=e.cloneRange();n.selectNodeContents(t);var s=n.intersection(e),i=s?s.toString():"";return""!=i}function h(e){for(var t,n=e.getNodes([3]),s=0;(t=n[s])&&!c(e,t);)++s;for(var i=n.length-1;(t=n[i])&&!c(e,t);)--i;return n.slice(s,i+1)}function g(e,t){if(e.attributes.length!=t.attributes.length)return!1;for(var n,s,i,r=0,o=e.attributes.length;o>r;++r)if(n=e.attributes[r],i=n.name,"class"!=i){if(s=t.attributes.getNamedItem(i),null===n!=(null===s))return!1;if(n.specified!=s.specified)return!1;if(n.specified&&n.nodeValue!==s.nodeValue)return!1}return!0}function m(e,t){for(var n,s=0,i=e.attributes.length;i>s;++s)if(n=e.attributes[s].name,(!t||!H(t,n))&&e.attributes[s].specified&&"class"!=n)return!0;return!1}function N(e){var t;return e&&1==e.nodeType&&((t=e.parentNode)&&9==t.nodeType&&"on"==t.designMode||D(e)&&!D(e.parentNode))}function v(e){return(D(e)||1!=e.nodeType&&D(e.parentNode))&&!N(e)}function y(e){return e&&1==e.nodeType&&!$.test(B(e,"display"))}function C(e){if(0==e.data.length)return!0;if(U.test(e.data))return!1;var t=B(e.parentNode,"whiteSpace");switch(t){case"pre":case"pre-wrap":case"-moz-pre-wrap":return!1;case"pre-line":if(/[\r\n]/.test(e.data))return!1}return y(e.previousSibling)||y(e.nextSibling)}function T(e){var t,n,s=[];for(t=0;n=e[t++];)s.push(new M(n.startContainer,n.startOffset),new M(n.endContainer,n.endOffset));return s}function E(e,t){for(var n,s,i,r=0,o=e.length;o>r;++r)n=e[r],s=t[2*r],i=t[2*r+1],n.setStartAndEnd(s.node,s.offset,i.node,i.offset)}function b(e,t){return L.isCharacterDataNode(e)?0==t?!!e.previousSibling:t==e.length?!!e.nextSibling:!0:t>0&&t<e.childNodes.length}function A(e,n,s,i){var r,o,a=0==s;if(L.isAncestorOf(n,e))return e;if(L.isCharacterDataNode(n)){var l=L.getNodeIndex(n);if(0==s)s=l;else{if(s!=n.length)throw t.createError("splitNodeAt() should not be called with offset in the middle of a data node ("+s+" in "+n.data);s=l+1}n=n.parentNode}if(b(n,s)){r=n.cloneNode(!1),o=n.parentNode,r.id&&r.removeAttribute("id");for(var u,d=0;u=n.childNodes[s];)f(u,r,d++,i);return f(r,o,L.getNodeIndex(n)+1,i),n==e?r:A(e,o,L.getNodeIndex(r),i)}if(e!=n){r=n.parentNode;var p=L.getNodeIndex(n);return a||p++,A(e,r,p,i)}return e}function S(e,t){return e.namespaceURI==t.namespaceURI&&e.tagName.toLowerCase()==t.tagName.toLowerCase()&&o(e,t)&&g(e,t)&&"inline"==B(e,"display")&&"inline"==B(t,"display")}function x(e){var t=e?"nextSibling":"previousSibling";return function(n,s){var i=n.parentNode,r=n[t];if(r){if(r&&3==r.nodeType)return r}else if(s&&(r=i[t],r&&1==r.nodeType&&S(i,r))){var o=r[e?"firstChild":"lastChild"];if(o&&3==o.nodeType)return o}return null}}function R(e){this.isElementMerge=1==e.nodeType,this.textNodes=[];var t=this.isElementMerge?e.lastChild:e;t&&(this.textNodes[0]=t)}function P(e,t,r){var o,a,l,f,u=this;u.cssClass=u.className=e;var d=null,p={};if("object"==typeof t&&null!==t){for("undefined"!=typeof t.elementTagName&&(t.elementTagName=t.elementTagName.toLowerCase()),r=t.tagNames,d=t.elementProperties,p=t.elementAttributes,a=0;f=q[a++];)t.hasOwnProperty(f)&&(u[f]=t[f]);o=t.normalize}else o=t;u.normalize="undefined"==typeof o?!0:o,u.attrExceptions=[];var c=document.createElement(u.elementTagName);u.elementProperties=u.copyPropertiesToElement(d,c,!0),n(p,function(e){u.attrExceptions.push(e)}),u.elementAttributes=p,u.elementSortedClassName=u.elementProperties.hasOwnProperty("className")?i(u.elementProperties.className+" "+e):e,u.applyToAnyTagName=!1;var h=typeof r;if("string"==h)"*"==r?u.applyToAnyTagName=!0:u.tagNames=s(r.toLowerCase()).split(/\s*,\s*/);else if("object"==h&&"number"==typeof r.length)for(u.tagNames=[],a=0,l=r.length;l>a;++a)"*"==r[a]?u.applyToAnyTagName=!0:u.tagNames.push(r[a].toLowerCase());else u.tagNames=[u.elementTagName]}function w(e,t,n){return new P(e,t,n)}var O,W,I,L=e.dom,M=L.DomPosition,H=L.arrayContains,j=L.isHtmlNamespace,z="span";e.util.isHostObject(document.createElement("div"),"classList")?(O=function(e,t){return e.classList.contains(t)},W=function(e,t){return e.classList.add(t)},I=function(e,t){return e.classList.remove(t)}):(O=function(e,t){return e.className&&new RegExp("(?:^|\\s)"+t+"(?:\\s|$)").test(e.className)},W=function(e,t){e.className?O(e,t)||(e.className+=" "+t):e.className=t},I=function(){function e(e,t,n){return t&&n?" ":""}return function(t,n){t.className&&(t.className=t.className.replace(new RegExp("(^|\\s)"+n+"(\\s|$)"),e))}}());var B=L.getComputedStyleProperty,D=function(){var e=document.createElement("div");return"boolean"==typeof e.isContentEditable?function(e){return e&&1==e.nodeType&&e.isContentEditable}:function(e){return e&&1==e.nodeType&&"false"!=e.contentEditable?"true"==e.contentEditable||D(e.parentNode):!1}}(),$=/^inline(-block|-table)?$/i,U=/[^\r\n\t\f \u200B]/,V=x(!1),k=x(!0);R.prototype={doMerge:function(e){var t=this.textNodes,n=t[0];if(t.length>1){for(var s,i,r,o,a=L.getNodeIndex(n),l=[],f=0,u=0,d=t.length;d>u;++u){if(s=t[u],i=s.parentNode,u>0&&(i.removeChild(s),i.hasChildNodes()||i.parentNode.removeChild(i),e))for(r=0;o=e[r++];)o.node==s&&(o.node=n,o.offset+=f),o.node==i&&o.offset>a&&(--o.offset,o.offset==a+1&&d-1>u&&(o.node=n,o.offset=f));l[u]=s.data,f+=s.data.length}n.data=l.join("")}return n.data},getLength:function(){for(var e=this.textNodes.length,t=0;e--;)t+=this.textNodes[e].length;return t},toString:function(){for(var e=[],t=0,n=this.textNodes.length;n>t;++t)e[t]="'"+this.textNodes[t].data+"'";return"[Merge("+e.join(",")+")]"}};var q=["elementTagName","ignoreWhiteSpace","applyToEditableOnly","useExistingElements","removeEmptyElements","onElementCreate"],F={};P.prototype={elementTagName:z,elementProperties:{},elementAttributes:{},ignoreWhiteSpace:!0,applyToEditableOnly:!1,useExistingElements:!0,removeEmptyElements:!0,onElementCreate:null,copyPropertiesToElement:function(e,t,n){var s,r,o,a,l,f,u={};for(var d in e)if(e.hasOwnProperty(d))if(a=e[d],l=t[d],"className"==d)W(t,a),W(t,this.className),t[d]=i(t[d]),n&&(u[d]=a);else if("style"==d){r=l,n&&(u[d]=o={});for(s in e[d])e[d].hasOwnProperty(s)&&(r[s]=a[s],n&&(o[s]=r[s]));this.attrExceptions.push(d)}else t[d]=a,n&&(u[d]=t[d],f=F.hasOwnProperty(d)?F[d]:d,this.attrExceptions.push(f));return n?u:""},copyAttributesToElement:function(e,t){for(var n in e)e.hasOwnProperty(n)&&t.setAttribute(n,e[n])},hasClass:function(e){return 1==e.nodeType&&(this.applyToAnyTagName||H(this.tagNames,e.tagName.toLowerCase()))&&O(e,this.className)},getSelfOrAncestorWithClass:function(e){for(;e;){if(this.hasClass(e))return e;e=e.parentNode}return null},isModifiable:function(e){return!this.applyToEditableOnly||v(e)},isIgnorableWhiteSpaceNode:function(e){return this.ignoreWhiteSpace&&e&&3==e.nodeType&&C(e)},postApply:function(e,t,n,s){for(var i,r,o,a=e[0],l=e[e.length-1],f=[],u=a,d=l,p=0,c=l.length,h=0,g=e.length;g>h;++h)r=e[h],o=V(r,!s),o?(i||(i=new R(o),f.push(i)),i.textNodes.push(r),r===a&&(u=i.textNodes[0],p=u.length),r===l&&(d=i.textNodes[0],c=i.getLength())):i=null;var m=k(l,!s);if(m&&(i||(i=new R(l),f.push(i)),i.textNodes.push(m)),f.length){for(h=0,g=f.length;g>h;++h)f[h].doMerge(n);t.setStartAndEnd(u,p,d,c)}},createContainer:function(e){var t=e.createElement(this.elementTagName);return this.copyPropertiesToElement(this.elementProperties,t,!1),this.copyAttributesToElement(this.elementAttributes,t),W(t,this.className),this.onElementCreate&&this.onElementCreate(t,this),t},elementHasProperties:function(e,t){var s=this;return n(t,function(t,n){if("className"==t)return i(e.className)==s.elementSortedClassName;if("object"==typeof n){if(!s.elementHasProperties(e[t],n))return!1}else if(e[t]!==n)return!1})},applyToTextNode:function(e){var t=e.parentNode;if(1==t.childNodes.length&&this.useExistingElements&&j(t)&&H(this.tagNames,t.tagName.toLowerCase())&&this.elementHasProperties(t,this.elementProperties))W(t,this.className);else{var n=this.createContainer(L.getDocument(e));e.parentNode.insertBefore(n,e),n.appendChild(e)}},isRemovable:function(e){return j(e)&&e.tagName.toLowerCase()==this.elementTagName&&r(e)==this.elementSortedClassName&&this.elementHasProperties(e,this.elementProperties)&&!m(e,this.attrExceptions)&&this.isModifiable(e)},isEmptyContainer:function(e){var t=e.childNodes.length;return 1==e.nodeType&&this.isRemovable(e)&&(0==t||1==t&&this.isEmptyContainer(e.firstChild))},removeEmptyContainers:function(e){for(var t,n=this,s=e.getNodes([1],function(e){return n.isEmptyContainer(e)}),i=[e],r=T(i),o=0;t=s[o++];)u(t,r);E(i,r)},undoToTextNode:function(e,t,n,s){if(!t.containsNode(n)){var i=t.cloneRange();i.selectNode(n),i.isPointInRange(t.endContainer,t.endOffset)&&(A(n,t.endContainer,t.endOffset,s),t.setEndAfter(n)),i.isPointInRange(t.startContainer,t.startOffset)&&(n=A(n,t.startContainer,t.startOffset,s))}this.isRemovable(n)?p(n,s):I(n,this.className)},splitAncestorWithClass:function(e,t,n){var s=this.getSelfOrAncestorWithClass(e);s&&A(s,e,t,n)},undoToAncestor:function(e,t){this.isRemovable(e)?p(e,t):I(e,this.className)},applyToRange:function(e,t){t=t||[];var n=T(t||[]);e.splitBoundariesPreservingPositions(n),this.removeEmptyElements&&this.removeEmptyContainers(e);var s=h(e);if(s.length){for(var i,r=0;i=s[r++];)this.isIgnorableWhiteSpaceNode(i)||this.getSelfOrAncestorWithClass(i)||!this.isModifiable(i)||this.applyToTextNode(i,n);i=s[s.length-1],e.setStartAndEnd(s[0],0,i,i.length),this.normalize&&this.postApply(s,e,n,!1),E(t,n)}},applyToRanges:function(e){for(var t=e.length;t--;)this.applyToRange(e[t],e);return e},applyToSelection:function(t){var n=e.getSelection(t);n.setRanges(this.applyToRanges(n.getAllRanges()))},undoToRange:function(e,t){t=t||[];var n=T(t);e.splitBoundariesPreservingPositions(n),this.removeEmptyElements&&this.removeEmptyContainers(e,n);var s,i,r=h(e),o=r[r.length-1];if(r.length){this.splitAncestorWithClass(e.endContainer,e.endOffset,n),this.splitAncestorWithClass(e.startContainer,e.startOffset,n);for(var a=0,l=r.length;l>a;++a)s=r[a],i=this.getSelfOrAncestorWithClass(s),i&&this.isModifiable(s)&&this.undoToAncestor(i,n);e.setStartAndEnd(r[0],0,o,o.length),this.normalize&&this.postApply(r,e,n,!0),E(t,n)}},undoToRanges:function(e){for(var t=e.length;t--;)this.undoToRange(e[t],e);return e},undoToSelection:function(t){var n=e.getSelection(t),s=e.getSelection(t).getAllRanges();this.undoToRanges(s),n.setRanges(s)},isAppliedToRange:function(e){if(e.collapsed||""==e.toString())return!!this.getSelfOrAncestorWithClass(e.commonAncestorContainer);var t=e.getNodes([3]);if(t.length)for(var n,s=0;n=t[s++];)if(!this.isIgnorableWhiteSpaceNode(n)&&c(e,n)&&this.isModifiable(n)&&!this.getSelfOrAncestorWithClass(n))return!1;return!0},isAppliedToRanges:function(e){var t=e.length;if(0==t)return!1;for(;t--;)if(!this.isAppliedToRange(e[t]))return!1;return!0},isAppliedToSelection:function(t){var n=e.getSelection(t);return this.isAppliedToRanges(n.getAllRanges())},toggleRange:function(e){this.isAppliedToRange(e)?this.undoToRange(e):this.applyToRange(e)},toggleSelection:function(e){this.isAppliedToSelection(e)?this.undoToSelection(e):this.applyToSelection(e)},getElementsWithClassIntersectingRange:function(e){var t=[],n=this;return e.getNodes([3],function(e){var s=n.getSelfOrAncestorWithClass(e);s&&!H(t,s)&&t.push(s)}),t},detach:function(){}},P.util={hasClass:O,addClass:W,removeClass:I,hasSameClasses:o,replaceWithOwnChildren:p,elementsHaveSameNonClassAttributes:g,elementHasNonClassAttributes:m,splitNodeAt:A,isEditableElement:D,isEditingHost:N,isEditable:v},e.CssClassApplier=e.ClassApplier=P,e.createCssClassApplier=e.createClassApplier=w})},this);