/*
rangy.config.checkSelectionRanges = false;

function getContainerElement() {
    var nodes = selectionNodes();
//    dumpNodes(nodes);
    if (nodes.firstNode.nodeType != 3) {
        return nodes.firstNode;
    } else {
        return nodes.commonContainer;
    }
}

function dumpNodes(nodes) {
    console.log('--- Dumping Nodes ---');
    for (var i = 0; i < nodes.nodes.length; i++) {
        var n = nodes.nodes[i];
        if (n.type == 'text') {
            console.log(n.type + ' - ' + n.text + ' Complete: ' + n.complete + ', Start: ' + n.start + ', End: ' + n.end);
        } else {
            console.log(n.type + ', Children: ' + n.children);
        }
    }
    console.log('----------------------');
}

function getSelectionStyle(key) {
    var containerEl = getContainerElement();

    if (containerEl) {
        if (window.getComputedStyle) {
            return window.getComputedStyle(containerEl, null)[key];
        } else if (containerEl.currentStyle) {
            return containerEl.currentStyle[key];
        }
    }
    return null;
}

function selectionNodes() {
    var s = rangy.getSelection();
    var range = s.getRangeAt(0);
    if (range.collapsed) {            // Special handling for collapsed
        var node = range.startContainer;
        if (node.nodeType == Node.TEXT_NODE) {
            node = node.parentNode;         // Make sure it's an element and
        }
        return {
            nodes: [range.startContainer],
            textComplete: false,
            firstNode: range.startContainer,
            lastNode: range.startContainer,
            commonContainer: node,
            properWrapper: false
        };
    }
    var foundEnd = false;
    var nodes = [];

    // Grab the parent if the selection represents the entire text block
    if (range.startContainer.nodeType == Node.TEXT_NODE && range.startContainer == range.endContainer && range.startOffset == 0 && range.startContainer.nodeValue.length == range.endOffset && range.startContainer.parentNode.childNodes.length == 1) {
//    if (s.focusNode.nodeType == Node.TEXT_NODE && s.anchorNode == s.focusNode && s.anchorOffset == 0 && s.anchorNode.nodeValue.length == s.focusOffset && s.focusNode.parentNode.childNodes.length == 1) {
        console.log('grabbing parent...');
        range.startContainer = range.startContainer.parentNode;
        range.endContainer = range.startContainer;
    }

    console.log('Range? ' + range.startContainer + ':' + range.startOffset + ', ' + range.endContainer + ':' + range.endOffset);

    function verifyAndAdd(node) {
        if (node == range.endContainer) {
            foundEnd = true;
        }
        if (node.nodeType == Node.TEXT_NODE) {
            var start = 0;
            var textLength = node.nodeValue.length;
            var end = textLength;
            if (node == range.startContainer) {
                start = range.startOffset;
            }
            if (node == range.endContainer) {
                end = range.endOffset;
            }
            var length = end - start;
            if (length > 0) {
//                console.log('text: ' + node + ', start: ' + start + ', end: ' + end + ', Anchor? ' + (node == s.anchorNode) + ', Focus? ' + (node == s.focusNode) + ', Offsets: ' + s.anchorOffset + 'x' + s.focusOffset + ', Nodes: ' + s.anchorNode + 'x' + s.focusNode);
                nodes.push({
                    type: 'text',
                    node: node,
                    start: start,
                    end: end,
                    text: node.nodeValue.substring(start, end),
                    complete: length == textLength
                });
            }
        } else {
            nodes.push({
                type: 'containerStart',
                node: node,
                children: node.childNodes.length
            });
            var before = nodes.length;
            if (node.hasChildNodes()) {
                verifyAndAdd(node.firstChild);
            }
            nodes.push({
                type: 'containerEnd',
                node: node,
                children: node.childNodes.length,
                complete: nodes.length - before == node.childNodes.length
            });
        }
        if (!foundEnd) {
            var nextSibling = node.nextSibling;
            if (nextSibling != null) {
                verifyAndAdd(nextSibling);
            }
        }
    }

    // Build nodes array
    verifyAndAdd(range.startContainer);

    var allComplete = true;
    for (var i = 0; i < nodes.length; i++) {
        var n = nodes[i];
        if (n.type == 'text') {
            if (!n.complete) {
                allComplete = false;
            }
        }
    }

    var firstNode = nodes[0];
    var lastNode = nodes[nodes.length - 1];
    var commonContainer = null;
    var properWrapper = false;
    if (allComplete && firstNode.type == 'containerStart' && lastNode.type == 'containerEnd' && firstNode.node == lastNode.node) {
        commonContainer = firstNode.node;
        properWrapper = true;
    } else {
        commonContainer = range.commonAncestorContainer;
        // Make sure we have an element rather than a text node
        if (commonContainer.nodeType == 3) {
            commonContainer = commonContainer.parentNode;
        }
    }

    return {
        nodes: nodes,
        textComplete: allComplete,
        firstNode: firstNode.node,
        lastNode: lastNode.node,
        commonContainer: commonContainer,
        properWrapper: properWrapper
    };
}
function toggleStyle(key, value, aliases) {
    var nodes = selectionNodes();
    if (aliases == null) aliases = [];
    var styleValues = (value + ', ' + aliases.join(', ')).toLowerCase();

    var addStyle = true;
    var currentStyle = getSelectionStyle(key);
    if (currentStyle == null) currentStyle = 'null';
    currentStyle = currentStyle.toLowerCase();
    if (styleValues.indexOf(currentStyle) != -1) {
        addStyle = false;
    }
//    console.log('addStyle? ' + addStyle + ', Current: ' + currentStyle + ', Value: ' + value + ', Equal: ' + (currentStyle == value) + ', Style Values: ' + styleValues);
//    if (!nodes.properWrapper && currentStyle == value) {
        dumpNodes(nodes);
//    }

    // Remove all style entries for children
    clearStyles(nodes.nodes, key);

    if (addStyle) {
        if (nodes.properWrapper) {
            nodes.commonContainer.style[key] = value;      // We have a proper wrapper node
        } else {
            createStylized(key, value);                    // We have to create a new node wrapper for the selection
        }
    }
}

function clearStyles(nodes, key) {
    for (var i = 0; i < nodes.length; i++) {
        var n = nodes[i];
        if (n.type == 'containerEnd' && n.complete) {
            console.log('Clearing: ' + n.node.style[key] + ' (' + key + ') ' + n.node);
            n.node.style[key] = null;
        }
    }
}

function createStylized(key, value) {
//    console.log('createStylized! ' + key + ' = ' + value);
    var span = document.createElement('span');
    span.style[key] = value;
    var range = rangy.getSelection().getRangeAt(0);
    span.appendChild(range.extractContents());
    range.insertNode(span);
    range = rangy.createRange();
    range.selectNodeContents(span);
    var s = rangy.getSelection();
    s.removeAllRanges();
    s.addRange(range);
}*/

function selectedNodes() {
    var range = rangy.getSelection().getRangeAt(0);
    var nodes = [];
    if (range.isCollapsed) {
        nodes.push({
            node: range.startContainer,
            start: range.startOffset,
            end: range.endOffset
        });
    } else {
        var foundEnd = false;

        console.log('-------------------- selectedNodes: ' + range.startContainer + '(' + range.startContainer.nodeValue + '):' + range.startOffset + ' - ' + range.endContainer + '(' + range.endContainer.nodeValue + '):' + range.endOffset);

        function verifyAndAdd(array, node) {
            if (node == range.endContainer) {
                foundEnd = true;
            }
            var start = 0;
            var length;
            var end;
            if (node.nodeType == Node.TEXT_NODE) {
                length = node.nodeValue.length;
            } else {
                length = node.childNodes.length;
            }
            end = length;
            if (node == range.startContainer) {
                start = range.startOffset;
            }
            if (node == range.endContainer) {
                end = range.endOffset;
            }
            if (end - start > 0) {             // Only include non-empty nodes
                if (node.nodeType == Node.TEXT_NODE) {
                    var t = {
                        type: 'text',
                        node: node,
                        start: start,
                        end: end,
                        text: node.nodeValue.substring(start, end),
                        length: length
                    };
                    array.push(t);
                    console.log('Adding text: ' + t.text);
                } else {
                    var children = [];
                    console.log('Begin container... ' + start + ' - ' + end);
                    verifyAndAdd(children, node.childNodes.item(start));
                    array.push({
                        type: 'container',
                        node: node,
                        start: start,
                        end: end,
                        length: length
                    });
                    console.log('Finish container');
                }
            }

            if (!foundEnd && node.nextSibling != null) {
                verifyAndAdd(array, node.nextSibling);
            }
        }
        verifyAndAdd(nodes, range.startContainer);
    }
    return nodes;
}

function spansForSelected() {
    var nodes = selectedNodes();
}

/**
 * Breaks the currently selected text into its own span if it isn't already and then returns it.
 */
function spanForSelection() {
    // TODO: should iterate through range siblings breaking out partials for spans and creating new spans as necessary
    // TODO: should return an array of spans

    var selection = rangy.getSelection();
    var range = selection.getRangeAt(0);
    var startNode = range.startContainer;
    var startOffset = range.startOffset;
    var endNode = range.endContainer;
    var endOffset = range.endOffset;
    if (startNode.nodeType == Node.TEXT_NODE && startNode.nodeValue.length == startOffset) {
        console.log('First node is empty!');
        startNode = startNode.nextSibling;
        startOffset = 0;
    }
    if (endNode.nodeType == Node.TEXT_NODE && endOffset == 0) {
        console.log('Last node is empty!');
        endNode = endNode.previousSibling;
        if (endNode.nodeType == Node.TEXT_NODE) {
            endOffset = endNode.nodeValue.length;
        } else {
            endOffset = endNode.childNodes.length;
        }
    }
    console.log('spanForSelection: ' + startNode + ':' + startOffset + ' - ' + endNode + ':' + endOffset + ' ' + range.commonAncestorContainer);
    if (startNode == endNode &&
        startNode.nodeType == Node.TEXT_NODE &&
        startOffset == 0 &&
        endOffset == endNode.nodeValue.length &&
        startNode.parentNode.classList.contains('stylized') &&
        startNode.parentNode.childNodes.length == 1) {
        console.log('Text element fully enclosed within stylized!');
        return startNode.parentNode;
    } else if (startNode == endNode &&
               startNode.nodeType == Node.ELEMENT_NODE &&
               startNode.classList.contains('stylized')) {
        console.log('Fully enclosed within stylized!');
        return startNode;
    } else if (startNode == endNode &&
               startNode.nodeType == Node.TEXT_NODE &&
               startNode.parentNode.classList.contains('stylized')) {
        console.log('Sub-text within stylized!');
        // TODO: extract left, extract right, insert all three back and apply styles
        var span = document.createElement('span');
        span.classList.add('stylized');
        span.appendChild(range.extractContents());
        range.insertNode(span);
        range = rangy.createRange();
        range.selectNodeContents(span);
        selection.removeAllRanges();
        selection.addRange(range);
        return span;
    } else if (startNode == endNode && startNode.nodeType == Node.TEXT_NODE) {
        console.log('Sub-text outside of stylized!');
        var span = document.createElement('span');
        span.classList.add('stylized');
        span.appendChild(range.extractContents());
        range.insertNode(span);
        range = rangy.createRange();
        range.selectNodeContents(span);
        selection.removeAllRanges();
        selection.addRange(range);
        return span;
    }
}