package org.hyperscala.jquery.ui

import org.powerscala.enum.{Enumerated, EnumEntry}
import org.hyperscala.html._

/**
 * @author Matt Hicks <matt@outr.com>
 */
class Icon private(val styleClass: String) extends EnumEntry {
  def create() = new tag.Span(clazz = List("ui-icon", styleClass))
}

object Icon extends Enumerated[Icon] {
    val carat1n = new Icon("ui-icon-carat-1-n")
    val carat1ne = new Icon("ui-icon-carat-1-ne")
    val carat1e = new Icon("ui-icon-carat-1-e")

    val carat1se = new Icon("ui-icon-carat-1-se")
    val carat1s = new Icon("ui-icon-carat-1-s")
    val carat1sw = new Icon("ui-icon-carat-1-sw")
    val carat1w = new Icon("ui-icon-carat-1-w")
    val carat1nw = new Icon("ui-icon-carat-1-nw")
    val carat2ns = new Icon("ui-icon-carat-2-n-s")
    val carat2ew = new Icon("ui-icon-carat-2-e-w")
    val triangle1n = new Icon("ui-icon-triangle-1-n")
    val triangle1ne = new Icon("ui-icon-triangle-1-ne")

    val triangle1e = new Icon("ui-icon-triangle-1-e")
    val triangle1se = new Icon("ui-icon-triangle-1-se")
    val triangle1s = new Icon("ui-icon-triangle-1-s")
    val triangle1sw = new Icon("ui-icon-triangle-1-sw")
    val triangle1w = new Icon("ui-icon-triangle-1-w")
    val triangle1nw = new Icon("ui-icon-triangle-1-nw")
    val triangle2ns = new Icon("ui-icon-triangle-2-n-s")
    val triangle2ew = new Icon("ui-icon-triangle-2-e-w")
    val arrow1n = new Icon("ui-icon-arrow-1-n")

    val arrow1ne = new Icon("ui-icon-arrow-1-ne")
    val arrow1e = new Icon("ui-icon-arrow-1-e")
    val arrow1se = new Icon("ui-icon-arrow-1-se")
    val arrow1s = new Icon("ui-icon-arrow-1-s")
    val arrow1sw = new Icon("ui-icon-arrow-1-sw")
    val arrow1w = new Icon("ui-icon-arrow-1-w")
    val arrow1nw = new Icon("ui-icon-arrow-1-nw")
    val arrow2ns = new Icon("ui-icon-arrow-2-n-s")
    val arrow2nesw = new Icon("ui-icon-arrow-2-ne-sw")

    val arrow2ew = new Icon("ui-icon-arrow-2-e-w")
    val arrow2senw = new Icon("ui-icon-arrow-2-se-nw")
    val arrowstop1n = new Icon("ui-icon-arrowstop-1-n")
    val arrowstop1e = new Icon("ui-icon-arrowstop-1-e")
    val arrowstop1s = new Icon("ui-icon-arrowstop-1-s")
    val arrowstop1w = new Icon("ui-icon-arrowstop-1-w")
    val arrowthick1n = new Icon("ui-icon-arrowthick-1-n")
    val arrowthick1ne = new Icon("ui-icon-arrowthick-1-ne")
    val arrowthick1e = new Icon("ui-icon-arrowthick-1-e")

    val arrowthick1se = new Icon("ui-icon-arrowthick-1-se")
    val arrowthick1s = new Icon("ui-icon-arrowthick-1-s")
    val arrowthick1sw = new Icon("ui-icon-arrowthick-1-sw")
    val arrowthick1w = new Icon("ui-icon-arrowthick-1-w")
    val arrowthick1nw = new Icon("ui-icon-arrowthick-1-nw")
    val arrowthick2ns = new Icon("ui-icon-arrowthick-2-n-s")
    val arrowthick2nesw = new Icon("ui-icon-arrowthick-2-ne-sw")
    val arrowthick2ew = new Icon("ui-icon-arrowthick-2-e-w")
    val arrowthick2senw = new Icon("ui-icon-arrowthick-2-se-nw")

    val arrowthickstop1n = new Icon("ui-icon-arrowthickstop-1-n")
    val arrowthickstop1e = new Icon("ui-icon-arrowthickstop-1-e")
    val arrowthickstop1s = new Icon("ui-icon-arrowthickstop-1-s")
    val arrowthickstop1w = new Icon("ui-icon-arrowthickstop-1-w")
    val arrowreturnthick1w = new Icon("ui-icon-arrowreturnthick-1-w")
    val arrowreturnthick1n = new Icon("ui-icon-arrowreturnthick-1-n")
    val arrowreturnthick1e = new Icon("ui-icon-arrowreturnthick-1-e")
    val arrowreturnthick1s = new Icon("ui-icon-arrowreturnthick-1-s")
    val arrowreturn1w = new Icon("ui-icon-arrowreturn-1-w")

    val arrowreturn1n = new Icon("ui-icon-arrowreturn-1-n")
    val arrowreturn1e = new Icon("ui-icon-arrowreturn-1-e")
    val arrowreturn1s = new Icon("ui-icon-arrowreturn-1-s")
    val arrowrefresh1w = new Icon("ui-icon-arrowrefresh-1-w")
    val arrowrefresh1n = new Icon("ui-icon-arrowrefresh-1-n")
    val arrowrefresh1e = new Icon("ui-icon-arrowrefresh-1-e")
    val arrowrefresh1s = new Icon("ui-icon-arrowrefresh-1-s")
    val arrow4 = new Icon("ui-icon-arrow-4")
    val arrow4diag = new Icon("ui-icon-arrow-4-diag")

    val extlink = new Icon("ui-icon-extlink")
    val newwin = new Icon("ui-icon-newwin")
    val refresh = new Icon("ui-icon-refresh")
    val shuffle = new Icon("ui-icon-shuffle")
    val transferew = new Icon("ui-icon-transfer-e-w")
    val transferthickew = new Icon("ui-icon-transferthick-e-w")
    val foldercollapsed = new Icon("ui-icon-folder-collapsed")
    val folderopen = new Icon("ui-icon-folder-open")
    val document = new Icon("ui-icon-document")

    val documentb = new Icon("ui-icon-document-b")
    val note = new Icon("ui-icon-note")
    val mailclosed = new Icon("ui-icon-mail-closed")
    val mailopen = new Icon("ui-icon-mail-open")
    val suitcase = new Icon("ui-icon-suitcase")
    val comment = new Icon("ui-icon-comment")
    val person = new Icon("ui-icon-person")
    val print = new Icon("ui-icon-print")
    val trash = new Icon("ui-icon-trash")

    val locked = new Icon("ui-icon-locked")
    val unlocked = new Icon("ui-icon-unlocked")
    val bookmark = new Icon("ui-icon-bookmark")
    val tag = new Icon("ui-icon-tag")
    val home = new Icon("ui-icon-home")
    val flag = new Icon("ui-icon-flag")
    val calculator = new Icon("ui-icon-calculator")
    val cart = new Icon("ui-icon-cart")
    val pencil = new Icon("ui-icon-pencil")

    val clock = new Icon("ui-icon-clock")
    val disk = new Icon("ui-icon-disk")
    val calendar = new Icon("ui-icon-calendar")
    val zoomin = new Icon("ui-icon-zoomin")
    val zoomout = new Icon("ui-icon-zoomout")
    val search = new Icon("ui-icon-search")
    val wrench = new Icon("ui-icon-wrench")
    val gear = new Icon("ui-icon-gear")
    val heart = new Icon("ui-icon-heart")

    val star = new Icon("ui-icon-star")
    val link = new Icon("ui-icon-link")
    val cancel = new Icon("ui-icon-cancel")
    val plus = new Icon("ui-icon-plus")
    val plusthick = new Icon("ui-icon-plusthick")
    val minus = new Icon("ui-icon-minus")
    val minusthick = new Icon("ui-icon-minusthick")
    val close = new Icon("ui-icon-close")
    val closethick = new Icon("ui-icon-closethick")

    val key = new Icon("ui-icon-key")
    val lightbulb = new Icon("ui-icon-lightbulb")
    val scissors = new Icon("ui-icon-scissors")
    val clipboard = new Icon("ui-icon-clipboard")
    val copy = new Icon("ui-icon-copy")
    val contact = new Icon("ui-icon-contact")
    val image = new Icon("ui-icon-image")
    val video = new Icon("ui-icon-video")
    val script = new Icon("ui-icon-script")
    val alert = new Icon("ui-icon-alert")

    val info = new Icon("ui-icon-info")
    val notice = new Icon("ui-icon-notice")
    val help = new Icon("ui-icon-help")
    val check = new Icon("ui-icon-check")
    val bullet = new Icon("ui-icon-bullet")
    val radiooff = new Icon("ui-icon-radio-off")
    val radioon = new Icon("ui-icon-radio-on")
    val pinw = new Icon("ui-icon-pin-w")
    val pins = new Icon("ui-icon-pin-s")
    val play = new Icon("ui-icon-play")
    val pause = new Icon("ui-icon-pause")

    val seeknext = new Icon("ui-icon-seek-next")
    val seekprev = new Icon("ui-icon-seek-prev")
    val seekend = new Icon("ui-icon-seek-end")
    val seekfirst = new Icon("ui-icon-seek-first")
    val stop = new Icon("ui-icon-stop")
    val eject = new Icon("ui-icon-eject")
    val volumeoff = new Icon("ui-icon-volume-off")
    val volumeon = new Icon("ui-icon-volume-on")
    val power = new Icon("ui-icon-power")

    val signaldiag = new Icon("ui-icon-signal-diag")
    val signal = new Icon("ui-icon-signal")
    val battery0 = new Icon("ui-icon-battery-0")
    val battery1 = new Icon("ui-icon-battery-1")
    val battery2 = new Icon("ui-icon-battery-2")
    val battery3 = new Icon("ui-icon-battery-3")
    val circleplus = new Icon("ui-icon-circle-plus")
    val circleminus = new Icon("ui-icon-circle-minus")
    val circleclose = new Icon("ui-icon-circle-close")

    val circletrianglee = new Icon("ui-icon-circle-triangle-e")
    val circletriangles = new Icon("ui-icon-circle-triangle-s")
    val circletrianglew = new Icon("ui-icon-circle-triangle-w")
    val circletrianglen = new Icon("ui-icon-circle-triangle-n")
    val circlearrowe = new Icon("ui-icon-circle-arrow-e")
    val circlearrows = new Icon("ui-icon-circle-arrow-s")
    val circlearroww = new Icon("ui-icon-circle-arrow-w")
    val circlearrown = new Icon("ui-icon-circle-arrow-n")
    val circlezoomin = new Icon("ui-icon-circle-zoomin")

    val circlezoomout = new Icon("ui-icon-circle-zoomout")
    val circlecheck = new Icon("ui-icon-circle-check")
    val circlesmallplus = new Icon("ui-icon-circlesmall-plus")
    val circlesmallminus = new Icon("ui-icon-circlesmall-minus")
    val circlesmallclose = new Icon("ui-icon-circlesmall-close")
    val squaresmallplus = new Icon("ui-icon-squaresmall-plus")
    val squaresmallminus = new Icon("ui-icon-squaresmall-minus")
    val squaresmallclose = new Icon("ui-icon-squaresmall-close")
    val gripdottedvertical = new Icon("ui-icon-grip-dotted-vertical")

    val gripdottedhorizontal = new Icon("ui-icon-grip-dotted-horizontal")
    val gripsolidvertical = new Icon("ui-icon-grip-solid-vertical")
    val gripsolidhorizontal = new Icon("ui-icon-grip-solid-horizontal")
    val gripsmalldiagonalse = new Icon("ui-icon-gripsmall-diagonal-se")
    val gripdiagonalse = new Icon("ui-icon-grip-diagonal-se")
}