/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.admin.template.authentication.support.service;

import java.util.ArrayList;
import java.util.List;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemMenuMapper;
import org.iartisan.admin.template.authentication.support.dbm.mapper.SystemRolePermissionMapper;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemMenuDO;
import org.iartisan.admin.template.authentication.support.dbm.model.SystemRolePermissionDO;
import org.iartisan.admin.template.authentication.support.service.entity.ResourceEntity;
import org.iartisan.runtime.utils.CollectionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceSupportService {
    @Autowired
    private SystemMenuMapper systemMenuMapper;
    @Autowired
    private SystemRolePermissionMapper systemRolePermissionMapper;

    public List<ResourceEntity> getResourceList() {
        ArrayList<ResourceEntity> result = new ArrayList<ResourceEntity>();
        List<SystemMenuDO> firstMenuList = this.systemMenuMapper.selectFirstMenus(new SystemMenuDO());
        if (CollectionUtil.isNotEmpty(firstMenuList)) {
            for (SystemMenuDO o : firstMenuList) {
                ResourceEntity firstEntity = new ResourceEntity();
                firstEntity.setTitle(o.getMenuName());
                firstEntity.setValue(o.getMenuId());
                SystemMenuDO dbQuery = new SystemMenuDO();
                dbQuery.setParentMenuId(o.getMenuId());
                List<SystemMenuDO> secondMenuList = this.systemMenuMapper.selectSecondMenus(dbQuery);
                ArrayList<ResourceEntity> secondData = new ArrayList<ResourceEntity>();
                if (CollectionUtil.isNotEmpty(secondMenuList)) {
                    for (SystemMenuDO second : secondMenuList) {
                        ResourceEntity secondEntity = new ResourceEntity();
                        secondEntity.setTitle(second.getMenuName());
                        secondEntity.setValue(second.getMenuId());
                        secondEntity.setData(new ArrayList<ResourceEntity>());
                        secondData.add(secondEntity);
                    }
                }
                firstEntity.setData(secondData);
                result.add(firstEntity);
            }
        }
        return result;
    }

    public List<ResourceEntity> getResourceListByRoleId(String roleId) {
        List<ResourceEntity> dbResult = this.getResourceList();
        if (CollectionUtil.isNotEmpty(dbResult)) {
            SystemRolePermissionDO dbQuery = new SystemRolePermissionDO();
            ArrayList<String> roles = new ArrayList<String>();
            roles.add(roleId);
            dbQuery.setRoleIds(roles);
            List<String> permissionIds = this.systemRolePermissionMapper.selectPermissions(dbQuery);
            for (ResourceEntity resourceEntity : dbResult) {
                if (CollectionUtil.isNotEmpty(resourceEntity.getData())) {
                    List<ResourceEntity> data = resourceEntity.getData();
                    for (ResourceEntity datum : data) {
                        if (!permissionIds.contains(datum.getValue())) continue;
                        datum.setChecked(true);
                    }
                    continue;
                }
                if (!permissionIds.contains(resourceEntity.getValue())) continue;
                resourceEntity.setChecked(true);
            }
        }
        return dbResult;
    }
}

