/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.admin.template.config.shiro;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.iartisan.runtime.env.EnvContextConfig;
import org.iartisan.runtime.utils.StringUtils;
import org.iartisan.runtime.web.authentication.AuthenticationService;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    private Map<String, String> filterMap = new LinkedHashMap<String, String>();
    private static final String _CONFIG = "iartisan.shiro.filter";
    private static final String anon = "anon";
    private static final String authc = "authc";

    public ShiroConfig() {
        this.setFilterMap();
    }

    public Map<String, String> getFilterMap() {
        return this.filterMap;
    }

    public void setFilterMap() {
        String filterPath = EnvContextConfig.get((String)_CONFIG, (Object)"");
        filterPath = filterPath + ",/assets/iartisan/**," + "/authenticate" + "," + "/login" + ",/webjars/**" + ",/captcha";
        List<String> filterPaths = Arrays.asList(filterPath.split(","));
        for (String path : filterPaths) {
            if (!StringUtils.isNotEmpty((String)path)) continue;
            this.filterMap.put(path, anon);
        }
        this.filterMap.put("/**", authc);
    }

    @Bean(value={"sessionManager"})
    public SessionManager sessionManager() {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionValidationSchedulerEnabled(true);
        sessionManager.setSessionIdUrlRewritingEnabled(true);
        return sessionManager;
    }

    @Bean(value={"securityManager"})
    public SecurityManager securityManager(AuthenticationService authenticationService, SessionManager sessionManager) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)authenticationService);
        securityManager.setSessionManager(sessionManager);
        return securityManager;
    }

    @Bean(value={"shiroFilter"})
    public ShiroFilterFactoryBean shirFilter(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilter = new ShiroFilterFactoryBean();
        shiroFilter.setSecurityManager(securityManager);
        shiroFilter.setLoginUrl("/login");
        shiroFilter.setUnauthorizedUrl("/");
        shiroFilter.setFilterChainDefinitionMap(this.getFilterMap());
        return shiroFilter;
    }

    @Bean(value={"lifecycleBeanPostProcessor"})
    public LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator proxyCreator = new DefaultAdvisorAutoProxyCreator();
        proxyCreator.setProxyTargetClass(true);
        return proxyCreator;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor advisor = new AuthorizationAttributeSourceAdvisor();
        advisor.setSecurityManager(securityManager);
        return advisor;
    }
}

