/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.admin.template.controller;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.iartisan.runtime.utils.StringUtils;
import org.iartisan.runtime.web.WebR;
import org.iartisan.runtime.web.authentication.RealmBean;
import org.iartisan.runtime.web.utils.WebUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AuthenticateController {
    @Value(value="${iartisan.admin.authenticate.success:index}")
    private String authenticateSuccessPage;
    @Value(value="${iartisan.admin.authenticate.error:login}")
    private String authenticateErrorPage;

    @ResponseBody
    @PostMapping(value={"/authenticate"})
    public WebR authenticate(RealmBean realmBean, String vercode) {
        WebR r = new WebR();
        if (StringUtils.isEmpty((String)realmBean.getUserName()) || StringUtils.isEmpty((String)realmBean.getUserPwd())) {
            r.isError("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!!");
            return r;
        }
        if (StringUtils.isEmpty((String)vercode) || !WebUtil.getShiroSession().getAttribute((Object)"KAPTCHA_SESSION_KEY").toString().equals(vercode)) {
            r.isError("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return r;
        }
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(realmBean.getUserName(), realmBean.getUserPwd());
        try {
            subject.login((AuthenticationToken)token);
            r.setMessage(this.authenticateSuccessPage);
        }
        catch (AuthenticationException e) {
            r.isError(e.getMessage());
        }
        return r;
    }

    @ResponseBody
    @GetMapping(value={"getMenus"})
    public WebR getMenus() {
        WebR webR = new WebR();
        RealmBean realmBean = (RealmBean)WebUtil.getShiroSession().getAttribute((Object)"_user");
        webR.setDataList(realmBean.getMenuTrees());
        return webR;
    }

    @GetMapping(value={"/logout"})
    public String logout() {
        WebUtil.getShiroSubject().logout();
        return "redirect:index";
    }
}

