/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.admin.template.controller.support;

import java.util.List;
import org.iartisan.admin.template.authentication.support.service.ResourceSupportService;
import org.iartisan.admin.template.authentication.support.service.RoleSupportService;
import org.iartisan.admin.template.authentication.support.service.entity.ResourceEntity;
import org.iartisan.admin.template.authentication.support.service.entity.RoleEntity;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.web.WebR;
import org.iartisan.runtime.web.controller.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"roleSupport"})
public class RoleSupportController
extends BaseController {
    private static final String VIEW_PREFIX = "role/";
    @Autowired
    private RoleSupportService roleSupportService;
    @Autowired
    private ResourceSupportService resourceSupportService;

    @GetMapping(value={"/index"})
    public String index() {
        return "role/role_index";
    }

    @ResponseBody
    @PostMapping(value={"queryPageData"})
    public WebR queryPageData(Page page, String roleName) {
        PageWrapper<RoleEntity> pageData = this.roleSupportService.getAuthPageData(page, roleName);
        WebR webR = new WebR(pageData.getPage());
        webR.setDataList(pageData.getDataList());
        return webR;
    }

    @GetMapping(value={"addDataPage"})
    public String addDataPage() {
        return "role/role_add";
    }

    @ResponseBody
    @PostMapping(value={"addData"})
    public WebR addData(RoleEntity roleEntity) {
        this.roleSupportService.addRole(roleEntity);
        WebR r = new WebR();
        return r;
    }

    @ResponseBody
    @GetMapping(value={"getResourceData"})
    public WebR getResourceData() {
        List<ResourceEntity> dataList = this.resourceSupportService.getResourceList();
        WebR r = new WebR();
        r.setDataList(dataList);
        return r;
    }

    @ResponseBody
    @GetMapping(value={"getResourceListByRoleId"})
    public WebR getResourceListByRoleId(String roleId) {
        List<ResourceEntity> dataList = this.resourceSupportService.getResourceListByRoleId(roleId);
        WebR r = new WebR();
        r.setDataList(dataList);
        return r;
    }

    @GetMapping(value={"queryDetailData"})
    public String queryDetailData(String roleId, Model model) {
        RoleEntity authEntity = this.roleSupportService.getAuthDetail(roleId);
        model.addAttribute("data", (Object)authEntity);
        return "role/role_detail";
    }

    @ResponseBody
    @PostMapping(value={"deleteData"})
    public WebR deleteData(String roleId) {
        this.roleSupportService.deleteRole(roleId);
        WebR r = new WebR();
        r.setMessage("\u5220\u9664\u89d2\u8272\u6210\u529f");
        return r;
    }
}

