/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.maven.plugin.handle;

import java.util.Arrays;
import org.apache.maven.plugin.logging.Log;
import org.iartisan.maven.plugin.exception.InvalidCommandException;
import org.iartisan.maven.plugin.handle.DaoGenerateHandler;
import org.iartisan.maven.plugin.log.LoggerFactory;
import org.iartisan.maven.plugin.mavenconfig.BaseConfig;
import org.iartisan.maven.plugin.mavenconfig.DaoPackageConfig;
import org.iartisan.maven.plugin.mavenconfig.DataSourceConfig;
import org.iartisan.maven.plugin.mavenconfig.PackageConfig;
import org.iartisan.maven.plugin.mavenconfig.TableConfig;
import org.iartisan.maven.plugin.mavenconfig.TemplateConfig;
import org.iartisan.maven.plugin.template.TemplateParse;

public class CommandExecutor {
    private TemplateConfig templateConfig;
    private BaseConfig baseConfig;
    private DataSourceConfig dataSourceConfig;
    private TableConfig tableConfig;
    private DaoPackageConfig daoConfig;
    private PackageConfig serviceConfig;
    private PackageConfig controllerConfig;
    private PackageConfig htmlPageConfig;
    private String[] commands = new String[]{"all", "service", "controller", "dao", "html"};
    private TemplateParse templateParse = new TemplateParse();
    protected static Log logger = LoggerFactory.getLogger();

    public CommandExecutor(TemplateConfig templateConfig, BaseConfig baseConfig, DataSourceConfig dataSourceConfig, TableConfig tableConfig, DaoPackageConfig daoConfig, PackageConfig serviceConfig, PackageConfig controllerConfig, PackageConfig htmlPageConfig) {
        this.templateConfig = templateConfig;
        this.baseConfig = baseConfig;
        this.dataSourceConfig = dataSourceConfig;
        this.tableConfig = tableConfig;
        this.daoConfig = daoConfig;
        this.serviceConfig = serviceConfig;
        this.controllerConfig = controllerConfig;
        this.htmlPageConfig = htmlPageConfig;
    }

    public void execute(String command) {
        try {
            if (null == this.baseConfig) {
                logger.error((CharSequence)"\u8bf7\u6dfbbaseConfig\u914d\u7f6e");
                return;
            }
            if (!Arrays.asList(this.commands).contains(command)) {
                throw new InvalidCommandException("\u65e0\u6548\u7684\u547d\u4ee4:" + command);
            }
            this.templateParse.initConfiguration(this.templateConfig);
            switch (command) {
                case "all": {
                    break;
                }
                case "dao": {
                    DaoGenerateHandler.doGenerate(this.templateParse, this.baseConfig, this.tableConfig, this.dataSourceConfig, this.daoConfig);
                    break;
                }
            }
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (osName.contains("Mac")) {
                    Runtime.getRuntime().exec("open " + this.baseConfig.getDirectory());
                } else if (osName.contains("Windows")) {
                    Runtime.getRuntime().exec("cmd /c start " + this.baseConfig.getDirectory());
                } else {
                    System.err.println("save dir:" + this.baseConfig.getDirectory());
                }
            }
            logger.info((CharSequence)"\u4ee3\u7801\u751f\u6210\u5b8c\u6210!!!");
        }
        catch (Exception e) {
            logger.info((CharSequence)"\u4ee3\u7801\u751f\u6210\u5f02\u5e38:", (Throwable)e);
        }
    }
}

