/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.maven.plugin.handle;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iartisan.maven.plugin.handle.BaseGenerateHandler;
import org.iartisan.maven.plugin.jdbc.DBUtil;
import org.iartisan.maven.plugin.jdbc.JdbcConnection;
import org.iartisan.maven.plugin.jdbc.MySQLTableHandler;
import org.iartisan.maven.plugin.jdbc.bean.TableColumn;
import org.iartisan.maven.plugin.mavenconfig.BaseConfig;
import org.iartisan.maven.plugin.mavenconfig.DaoPackageConfig;
import org.iartisan.maven.plugin.mavenconfig.DataSourceConfig;
import org.iartisan.maven.plugin.mavenconfig.TableConfig;
import org.iartisan.maven.plugin.template.TemplateParse;
import org.iartisan.maven.plugin.utils.FileUtil;
import org.iartisan.maven.plugin.utils.StringUtil;

public class DaoGenerateHandler
extends BaseGenerateHandler {
    private static final String MODEL_PACKAGE = "modelPackage";
    private static final String DAO_PACKAGE = "daoPackage";
    private static final String DAO_IMPL_PACKAGE = "daoImplPackage";
    private static final String TABLE_NAME = "tableName";

    static void doGenerate(TemplateParse templateParse, BaseConfig baseConfig, TableConfig tableConfig, DataSourceConfig dataSourceConfig, DaoPackageConfig daoConfig) throws SQLException, ClassNotFoundException, IOException, TemplateException, IllegalAccessException {
        logger.info((CharSequence)"\u5f00\u59cb\u751f\u6210DAO\u5c42\u4ee3\u7801");
        if (tableConfig == null) {
            logger.error((CharSequence)"\u8bf7\u6dfb\u52a0tableConfig\u914d\u7f6e");
            return;
        }
        if (dataSourceConfig == null) {
            logger.error((CharSequence)"\u8bf7\u6dfb\u52a0daoConfig\u914d\u7f6e");
            return;
        }
        String dbType = dataSourceConfig.getDbType();
        Connection connection = JdbcConnection.getConnection(dataSourceConfig);
        if ("mysql".equals(dbType)) {
            String[] tableNames;
            MySQLTableHandler mySQLTableHandler = new MySQLTableHandler(connection);
            for (String tableName : tableNames = tableConfig.getTableNames().split(",")) {
                logger.info((CharSequence)("\u5f00\u59cb\u751f\u6210\u8868[" + tableName + "]\u4ee3\u7801"));
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                List<TableColumn> tableColumnList = mySQLTableHandler.getTableFields(tableName);
                HashMap<String, String> map = new HashMap<String, String>();
                for (TableColumn tableColumn : tableColumnList) {
                    map.put(tableColumn.getJavaType(), tableColumn.getJavaType());
                }
                ArrayList<String> importPackages = new ArrayList<String>();
                for (Map.Entry entry : map.entrySet()) {
                    importPackages.add(DBUtil.getImportPackage((String)entry.getKey()));
                }
                dataMap.put("importPackages", importPackages);
                String string = DBUtil.getTableBeanName(tableName, false);
                dataMap.put("beanName", string);
                dataMap.put("beanAttributes", tableColumnList);
                String modelPackage = daoConfig.getModelPackage();
                dataMap.put(MODEL_PACKAGE, modelPackage);
                dataMap.put(TABLE_NAME, tableName);
                dataMap.put("author", baseConfig.getAuthor());
                String modelContent = templateParse.render("model/Model.ftl", dataMap);
                String daoPackage = daoConfig.getDaoPackage();
                dataMap.put(DAO_PACKAGE, daoPackage);
                String daoContent = templateParse.render("dao/Dao.ftl", dataMap);
                if (StringUtil.isNotEmpty(baseConfig.getOrm()) && baseConfig.getOrm().equals(BaseConfig.ORM.mybatis_plus.getCode())) {
                    FileUtil.writeToFile(string + "Mapper.java", FileUtil.getFilePath(baseConfig.getDirectory(), daoPackage), daoContent);
                } else {
                    FileUtil.writeToFile(string + "DAO.java", FileUtil.getFilePath(baseConfig.getDirectory(), daoPackage), daoContent);
                    String daoImplPackage = daoPackage + ".impl";
                    dataMap.put(DAO_IMPL_PACKAGE, daoImplPackage);
                    String daoImplContent = templateParse.render("dao/impl/DaoImpl.ftl", dataMap);
                    FileUtil.writeToFile(string + "DAOImpl.java", FileUtil.getFilePath(baseConfig.getDirectory(), daoImplPackage), daoImplContent);
                }
                FileUtil.writeToFile(string + "DO.java", FileUtil.getFilePath(baseConfig.getDirectory(), modelPackage), modelContent);
                String mapperContent = templateParse.render("mapper/Mapper.ftl", dataMap);
                FileUtil.writeToFile(string + "Mapper.xml", FileUtil.getFilePath(baseConfig.getDirectory(), daoConfig.getMapperXmlPackage()), mapperContent);
                FileUtil.writeToFile(string + "Mapper.xml", FileUtil.getFilePath(baseConfig.getDirectory(), daoConfig.getMapperXmlPackage()), mapperContent);
            }
        }
    }
}

