/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.maven.plugin.jdbc;

import org.iartisan.maven.plugin.utils.BeanUtil;
import org.iartisan.maven.plugin.utils.StringUtil;

public class DBUtil {
    public static String getProperty(String field) {
        if (!field.contains("_")) {
            if (StringUtil.isUpperCase(field)) {
                return field.toLowerCase();
            }
            return field;
        }
        StringBuilder sb = new StringBuilder();
        String[] fields = field.split("_");
        sb.append(fields[0].toLowerCase());
        for (int i = 1; i < fields.length; ++i) {
            String temp = fields[i];
            sb.append(temp.substring(0, 1).toUpperCase());
            sb.append(temp.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String getJdbcType(String mysqlType) {
        String t = mysqlType.toLowerCase();
        if (t.contains("char") || t.contains("varchar")) {
            return "VARCHAR";
        }
        if (t.contains("int")) {
            return "INTEGER";
        }
        if (t.contains("timestamp") || t.contains("datetime")) {
            return "TIMESTAMP";
        }
        if (t.contains("decimal")) {
            return "DECIMAL";
        }
        return t.toUpperCase();
    }

    public static String getJavaType(String jdbcType) {
        String t = jdbcType.toLowerCase();
        if (t.contains("char")) {
            return "String";
        }
        if (t.contains("bigint")) {
            return "Long";
        }
        if (t.contains("int")) {
            return "Integer";
        }
        if (t.contains("date") || t.contains("timestamp")) {
            return "Date";
        }
        if (t.contains("text")) {
            return "String";
        }
        if (t.contains("bit")) {
            return "Boolean";
        }
        if (t.contains("decimal")) {
            return "BigDecimal";
        }
        if (t.contains("blob")) {
            return "byte[]";
        }
        if (t.contains("float")) {
            return "Float";
        }
        if (t.contains("double")) {
            return "Double";
        }
        if (t.contains("json") || t.contains("enum")) {
            return "String";
        }
        return jdbcType;
    }

    public static String getImportPackage(String javaType) {
        if (!StringUtil.isEmpty(javaType)) {
            if (BeanUtil.isDate(javaType)) {
                return "import java.util.Date";
            }
            if (BeanUtil.isDecimal(javaType)) {
                return "import java.math.BigDecimal";
            }
        }
        return null;
    }

    public static String getTableBeanName(String table, boolean includePrefix) {
        StringBuilder sb = new StringBuilder();
        if (table.contains("_")) {
            String[] tables = table.split("_");
            int l = tables.length;
            int s = 0;
            if (includePrefix) {
                s = 1;
            }
            for (int i = s; i < l; ++i) {
                String temp = tables[i].trim();
                sb.append(temp.substring(0, 1).toUpperCase()).append(temp.substring(1).toLowerCase());
            }
        } else {
            sb.append(table.substring(0, 1).toUpperCase()).append(table.substring(1).toLowerCase());
        }
        return sb.toString();
    }
}

