/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.maven.plugin.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iartisan.maven.plugin.exception.DBParseException;
import org.iartisan.maven.plugin.jdbc.DBUtil;
import org.iartisan.maven.plugin.jdbc.TableHandler;
import org.iartisan.maven.plugin.jdbc.bean.TableColumn;

public class MySQLTableHandler
implements TableHandler {
    private Connection connection;
    public static final String sql_show_tables = "show tables";
    public static final String sql_show_fields = "show full fields from %s";
    public static final String FIELD = "FIELD";
    public static final String TYPE = "TYPE";
    public static final String COMMENT = "COMMENT";
    public static final String KEY = "KEY";

    public MySQLTableHandler(Connection connection) {
        this.connection = connection;
    }

    @Override
    public List<String> getTables(String[] tableNames) throws SQLException, DBParseException {
        ArrayList<String> tables = new ArrayList<String>();
        PreparedStatement pstate = this.connection.prepareStatement(sql_show_tables);
        ResultSet results = pstate.executeQuery();
        while (results.next()) {
            tables.add(results.getString(1));
        }
        if (null == tableNames || tableNames.length == 0) {
            return tables;
        }
        List<String> custTables = Arrays.asList(tableNames);
        ArrayList<String> notExistTables = new ArrayList<String>();
        for (String tb : custTables) {
            if (tables.contains(tb)) continue;
            notExistTables.add(tb);
        }
        if (notExistTables.size() == 0) {
            return custTables;
        }
        throw new DBParseException("\u8868:" + ((Object)notExistTables).toString() + "\u4e0d\u5b58\u5728");
    }

    @Override
    public List<TableColumn> getTableFields(String tableName) throws SQLException {
        String sql = String.format(sql_show_fields, tableName);
        ResultSet results = this.connection.prepareStatement(sql).executeQuery();
        ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
        while (results.next()) {
            String field = results.getString(FIELD);
            String type = results.getString(TYPE);
            String comment = results.getString(COMMENT);
            String key = results.getString(KEY);
            TableColumn column = new TableColumn();
            column.setColumn(field);
            column.setProperty(DBUtil.getProperty(field));
            column.setComment(comment);
            column.setJdbcType(DBUtil.getJdbcType(type));
            column.setJavaType(DBUtil.getJavaType(column.getJdbcType()));
            if ("PRI".equals(key)) {
                column.setPrimaryKey(true);
            }
            tableColumns.add(column);
        }
        return tableColumns;
    }
}

