/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.maven.plugin.template;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.iartisan.maven.plugin.log.LoggerFactory;
import org.iartisan.maven.plugin.mavenconfig.TemplateConfig;
import org.iartisan.maven.plugin.utils.StringUtil;

public class TemplateParse {
    protected Configuration configuration;
    private static final String DEFAULT_TEMPLATE_PATH = "/templates/iartisan/";
    private static Log logger = LoggerFactory.getLogger();

    public void initConfiguration(TemplateConfig config) throws IOException {
        if (null != config) {
            Configuration cfg = new Configuration(new Version("2.3.0"));
            ClassTemplateLoader loader = null;
            if (config.getLoadPath().equals(TemplateConfig.Path.classpath.toString())) {
                loader = new ClassTemplateLoader(this.getClass(), !StringUtil.isEmpty(config.getTemplatePath()) ? config.getTemplatePath() : DEFAULT_TEMPLATE_PATH);
            } else if (config.getLoadPath().equals(TemplateConfig.Path.file.toString())) {
                loader = new FileTemplateLoader(new File(config.getTemplatePath()));
            }
            cfg.setTemplateLoader(loader);
            cfg.setDefaultEncoding("UTF-8");
            this.configuration = cfg;
        }
    }

    public String render(String ftlPath, Map<String, Object> data) throws IllegalAccessException, IOException, TemplateException {
        logger.info((CharSequence)("root render dir:" + this.configuration.getTemplateLoader().toString()));
        logger.info((CharSequence)("render:" + ftlPath));
        Template template = this.configuration.getTemplate(ftlPath);
        StringWriter writer = new StringWriter();
        if (null == template) {
            throw new IllegalAccessException("\u5148\u521d\u59cb\u5316template\u914d\u7f6e");
        }
        template.process(data, (Writer)writer);
        return writer.toString();
    }
}

