<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper
        PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN"
        "http://mybatis.org/dtd/mybatis-3-mapper.dtd">
<mapper namespace="${beanName!''}DO">

    <resultMap id="BaseResultMap" type="${modelPackage!''}.${beanName!''}DO">
    <#list beanAttributes as attribute >
        <#if (attribute.primaryKey)=true >
            <id column="${attribute.column!''}" property="${attribute.property!''}" jdbcType="${attribute.jdbcType!''}"/>
        <#else>
            <result column="${attribute.column!''}" property="${attribute.property!''}" jdbcType="${attribute.jdbcType!''}"/>
        </#if>
    </#list>
    </resultMap>

    <sql id="WHERE_CLAUSE">
        <where>
            1=1
        <#list beanAttributes as attribute >
            <if test="${attribute.property} != null and ${attribute.property} != ''">
                AND ${attribute.column} = ${'#'}{${attribute.property},jdbcType=${attribute.jdbcType}}
            </if>
        </#list>
        </where>
    </sql>

    <sql id="Base_Column_List">
    <#list beanAttributes as attribute >${attribute.column!''}<#if attribute_has_next>,</#if></#list>
    </sql>

    <select id="queryAll" resultMap="BaseResultMap">
        select
        <include refid="Base_Column_List"/>
        from
    ${tableName!''}
    </select>

    <select id="query" resultMap="BaseResultMap">
        select
        <include refid="Base_Column_List"/>
        from
    ${tableName!''}
        <if test="_parameter != null">
            <include refid="WHERE_CLAUSE"/>
        </if>
    </select>

    <select id="queryOne" resultMap="BaseResultMap">
        select
        <include refid="Base_Column_List"/>
        from
    ${tableName!''}
        <if test="_parameter != null">
            <include refid="WHERE_CLAUSE"/>
        </if>
    </select>

    <select id="count" parameterType="${modelPackage!''}.${beanName!''}DO" resultType="java.lang.Integer">
        select
        count(*)
        from
    ${tableName!''}
        <if test="_parameter != null">
            <include refid="WHERE_CLAUSE"/>
        </if>
    </select>

    <update id="update" parameterType="${modelPackage!''}.${beanName!''}DO">
        update ${tableName!''}
        <set>
        <#list beanAttributes as attribute >
            <if test="${attribute.property} != null and ${attribute.property} != ''">
            ${attribute.column} = ${'#'}{${attribute.property},jdbcType=${attribute.jdbcType}}<#if attribute_has_next>,</#if>
            </if>
        </#list>
        </set>
        <where>
        <#list beanAttributes as attribute >
            <#if (attribute.primaryKey)=true >
            ${attribute.column} = ${'#'}{${attribute.property},jdbcType=${attribute.jdbcType}}
            </#if>
        </#list>
        </where>
    </update>

    <insert id="add" parameterType="${modelPackage!''}.${beanName!''}DO">
        insert into ${tableName!''}(
    <#list beanAttributes as attribute >
    ${attribute.column!''}<#if attribute_has_next>,</#if>
    </#list>
        )values(
    <#list beanAttributes as attribute >
    ${'#'}{${attribute.property},jdbcType=${attribute.jdbcType}}<#if attribute_has_next>,</#if>
    </#list>
        )
    </insert>

    <delete id="delete" parameterType="${modelPackage!''}.${beanName!''}DO">
        delete from ${tableName!''}
        <if test="_parameter != null">
            <include refid="WHERE_CLAUSE"/>
        </if>
    </delete>
</mapper>