package org.iartisan.runtime.jdbc;

import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.bean.PageWrapper;

/**
 * @author King
 * @since 2018/2/26
 */
public class PageHelper {

    public static <DO> PageWrapper<DO> getAllPageData(MybatisBaseMapper<DO> baseMapper, Page page) {
        com.baomidou.mybatisplus.plugins.Page<DO> dbPage = new com.baomidou.mybatisplus.plugins.Page();
        dbPage.setCurrent(page.getCurrPage());
        dbPage.setSize(page.getPageSize());
        Wrapper wrapper = Condition.EMPTY;
        SqlHelper.fillWrapper(dbPage, wrapper);
        dbPage.setRecords(baseMapper.selectPage(dbPage, wrapper));
        Page resPage = new Page();
        resPage.setCurrPage(dbPage.getCurrent());
        resPage.setPageSize(dbPage.getSize());
        resPage.setTotalRecords(dbPage.getTotal());
        resPage.setTotalPage(dbPage.getPages());
        PageWrapper<DO> paginationBean = new PageWrapper(resPage);
        paginationBean.setDataList(dbPage.getRecords());
        return paginationBean;
    }

    public static <DO> PageWrapper<DO> getPageData(MybatisBaseMapper<DO> baseMapper, Page page, DO paramter) {
        com.baomidou.mybatisplus.plugins.Page<DO> dbPage = new com.baomidou.mybatisplus.plugins.Page();
        dbPage.setCurrent(page.getCurrPage());
        dbPage.setSize(page.getPageSize());
        Wrapper wrapper = new EntityWrapper(paramter);
        SqlHelper.fillWrapper(dbPage, wrapper);
        dbPage.setRecords(baseMapper.selectPage(dbPage, wrapper));
        Page resPage = new Page();
        resPage.setCurrPage(dbPage.getCurrent());
        resPage.setPageSize(dbPage.getSize());
        resPage.setTotalRecords(dbPage.getTotal());
        resPage.setTotalPage(dbPage.getPages());
        PageWrapper<DO> paginationBean = new PageWrapper(resPage);
        paginationBean.setDataList(dbPage.getRecords());
        return paginationBean;
    }
}
