package org.iartisan.runtime.support;


import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import org.iartisan.runtime.jdbc.MybatisBaseMapper;
import org.iartisan.runtime.utils.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;

/**
 * <p>
 * management service support
 *
 * @author King
 * @since 2017/6/22
 */
public class BaseManagementServiceSupport<M extends MybatisBaseMapper<DO>, DO, T> implements IBaseManagementService<T> {

    @Autowired
    protected M baseMapper;

    private Class tClass;

    private Logger logger = LoggerFactory.getLogger(getClass());

    private Class<T> getTClass() {
        if (tClass == null) {
            tClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[2];
        }
        return tClass;

    }

    private Class doClass;

    private Class<DO> getDoClass() {
        if (doClass == null) {
            doClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        }
        return doClass;

    }


    @Override
    public void updateData(T t) {
        DO dbModify = BeanUtil.copyBean(t, getDoClass());
        baseMapper.updateById(dbModify);
    }

    @Override
    public void deleteData(T t) {
        DO dbDel = BeanUtil.copyBean(t, getDoClass());
        Wrapper<DO> wrapper = new EntityWrapper(dbDel);
        baseMapper.delete(wrapper);
    }

    @Override
    public void saveData(T t) {
        DO dbInsert = BeanUtil.copyBean(t, getDoClass());
        baseMapper.insert(dbInsert);
    }

    @Override
    public void deleteDataById(Serializable id) {
        baseMapper.deleteById(id);
    }
}
