package org.iartisan.runtime.support;


import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.jdbc.MybatisBaseMapper;
import org.iartisan.runtime.utils.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;


/**
 * <p>
 * query service support
 *
 * @author King
 * @since 2017/6/22
 */
public class BaseQueryServiceSupport<M extends MybatisBaseMapper<DO>, DO, T> implements IBaseQueryService<T> {

    @Autowired
    protected M baseMapper;

    private Class tClass;

    private Logger logger = LoggerFactory.getLogger(getClass());

    private Class<T> getTClass() {
        if (tClass == null) {
            tClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[2];
        }
        return tClass;

    }

    private Class doClass;

    private Class<DO> getDoClass() {
        if (doClass == null) {
            doClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        }
        return doClass;

    }

    @Override
    public PageWrapper<T> getAllPageData(Page page) {
        try {
            com.baomidou.mybatisplus.plugins.Page<DO> dbPage = new com.baomidou.mybatisplus.plugins.Page();
            dbPage.setCurrent(page.getCurrPage());
            dbPage.setSize(page.getPageSize());
            Wrapper wrapper = Condition.EMPTY;
            SqlHelper.fillWrapper(dbPage, wrapper);
            dbPage.setRecords(baseMapper.selectPage(dbPage, wrapper));
            List<T> dataList = BeanUtil.copyList(dbPage.getRecords(), getTClass());
            Page resPage = new Page();
            resPage.setCurrPage(dbPage.getCurrent());
            resPage.setPageSize(dbPage.getSize());
            resPage.setTotalRecords(dbPage.getTotal());
            resPage.setTotalPage(dbPage.getPages());
            PageWrapper<T> paginationBean = new PageWrapper(resPage);
            paginationBean.setDataList(dataList);
            return paginationBean;
        } catch (Exception e) {
            logger.error("getAllPageData Exception:", e);
        }
        return null;
    }

    @Override
    public PageWrapper<T> getPageData(Page page, T t) {
        try {
            com.baomidou.mybatisplus.plugins.Page<DO> dbPage = new com.baomidou.mybatisplus.plugins.Page();
            dbPage.setCurrent(page.getCurrPage());
            dbPage.setSize(page.getPageSize());
            DO dbQuery = BeanUtil.copyBean(t, getDoClass());
            Wrapper<DO> wrapper = new EntityWrapper(dbQuery);
            SqlHelper.fillWrapper(dbPage, wrapper);
            dbPage.setRecords(baseMapper.selectPage(dbPage, wrapper));
            List<T> dataList = BeanUtil.copyList(dbPage.getRecords(), getTClass());
            Page resPage = new Page();
            resPage.setCurrPage(dbPage.getCurrent());
            resPage.setPageSize(dbPage.getSize());
            resPage.setTotalRecords(dbPage.getTotal());
            resPage.setTotalPage(dbPage.getPages());
            PageWrapper<T> paginationBean = new PageWrapper(resPage);
            paginationBean.setDataList(dataList);
            return paginationBean;
        } catch (Exception e) {
            logger.error("getAllPageData Exception:", e);
        }
        return null;
    }

    @Override
    public List<T> getAllData() {
        try {
            Wrapper<DO> wrapper = new EntityWrapper();
            List<DO> dbResult = baseMapper.selectList(wrapper);
            return BeanUtil.copyList(dbResult, getTClass());
        } catch (Exception e) {
            logger.error("getAllList Exception:", e);
        }
        return null;
    }

    @Override
    public List<T> getListDataByObjs(T t) {
        DO dbQuery = BeanUtil.copyBean(t, getDoClass());
        Wrapper<DO> wrapper = new EntityWrapper(dbQuery);
        List<DO> dbResult = baseMapper.selectList(wrapper);
        List<T> dataList = BeanUtil.copyList(dbResult, getTClass());
        return dataList;
    }

    @Override
    public T getDataById(Serializable id) {
        DO dbResult = baseMapper.selectById(id);
        T obj = BeanUtil.copyBean(dbResult, getTClass());
        return obj;
    }

    @Override
    public T getDataByObjs(T t) {
        return null;
    }
}
