package org.iartisan.runtime.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * <p>
 * date util
 *
 * @author King
 * @since 2017/12/21
 */
public class DateUtils {

    public static String YYYY_MM_DD = "yyyy-MM-dd";

    public static String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public static Date toDate(String dateStr) {
        return toDate(dateStr, YYYY_MM_DD);
    }

    public static Date toDateTime(String dateStr) {
        return toDate(dateStr, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date toDate(String dateStr, String format) {
        if (dateStr == null || dateStr.isEmpty()) return null;
        DateFormat dateFormat = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = dateFormat.parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String formatDate(Date date) {
        return formatDate(date, YYYY_MM_DD);
    }

    public static String formatDateTime(Date date) {
        return formatDate(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static String formatDate(Date date, String format) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = new SimpleDateFormat(format);
        String dateStr = dateFormat.format(date);
        return dateStr;
    }
}
