package org.iartisan.runtime.utils;

import java.util.Date;
import java.util.UUID;

/**
 * <p>
 * uuid util
 *
 * @author King
 * @since 2018/1/3
 */
public class UUIDUtil {

    public static String timeBaseId() {
        return timeBaseId(24);
    }

    public static String timeBaseId(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DateUtils.formatDate(new Date(), DateUtils.YYYY_MM_DD));
        UUID uuid = UUID.randomUUID();
        stringBuilder.append(Math.abs(uuid.getMostSignificantBits()));
        stringBuilder.append(Math.abs(uuid.getLeastSignificantBits()));
        stringBuilder.setLength(length);
        return stringBuilder.toString();
    }

    public static String shortId() {
        return timeBaseId();
    }

}
