package org.iartisan.runtime.web;

import org.iartisan.runtime.bean.Page;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 后台返回前端对象
 *
 * @author King
 * @since 2017/4/27
 */
public class WebR implements Serializable {

    private static final String SUCCESS_CODE = "000000";

    private static final String SUCCESS_MSG = "成功";

    private static final String ERROR_CODE = "E00000";

    private String code;

    private String message;

    private List<?> dataList;

    private Object dataObject;

    private int pageSize = 10;

    private int totalPage;

    private int currPage = 1;

    private int totalRecords;

    //初始化默认成功
    public WebR() {
        this.code = SUCCESS_CODE;
        this.message = SUCCESS_MSG;
    }

    //分页返回初始化
    public WebR(Page page) {
        this.code = SUCCESS_CODE;
        this.message = SUCCESS_MSG;
        this.pageSize = page.getPageSize();
        this.totalPage = page.getTotalPage();
        this.currPage = page.getPageSize();
        this.totalRecords = page.getTotalRecords();
    }

    //置为失败
    public void isError(String message) {
        setCode(ERROR_CODE);
        setMessage(message);
    }

    //置为成功
    public void isSuccess(String message) {
        setCode(SUCCESS_CODE);
        setMessage(SUCCESS_MSG);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<?> getDataList() {
        return dataList;
    }

    public void setDataList(List<?> dataList) {
        this.dataList = dataList;
    }

    public Object getDataObject() {
        return dataObject;
    }

    public void setDataObject(Object dataObject) {
        this.dataObject = dataObject;
    }


    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getCurrPage() {
        return currPage;
    }

    public void setCurrPage(int currPage) {
        this.currPage = currPage;
    }

    public int getTotalRecords() {
        return totalRecords;
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords;
    }
}
