/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.iartisan.runtime.env.EnvContextConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvPropertiesLoader {
    private static Logger logger = LoggerFactory.getLogger((String)"env");
    private static String DEFAULT_CONF_FILE_NAME = "env.properties";
    private static String DEFAULT_CONF_FILE = File.separator + "wls" + File.separator + "envconfig" + File.separator + DEFAULT_CONF_FILE_NAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadLocalFile() {
        InputStream input;
        Properties filePropIn;
        block5: {
            filePropIn = new Properties();
            input = null;
            try {
                input = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_CONF_FILE_NAME);
                if (input == null) {
                    ResourceBundle res = ResourceBundle.getBundle("env");
                    Set<String> keys = res.keySet();
                    for (String key : keys) {
                        filePropIn.put(key, res.getString(key));
                    }
                    break block5;
                }
                filePropIn.load(input);
            }
            catch (Exception exception) {
                EnvPropertiesLoader.closeStream(input);
            }
            catch (Throwable throwable) {
                EnvPropertiesLoader.closeStream(input);
                throw throwable;
            }
        }
        EnvPropertiesLoader.closeStream(input);
        return filePropIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadOutFile(String filePath) {
        Properties filePropOut = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(filePath);
            filePropOut.load(input);
            logger.info("\u5916\u7f6e\u914d\u7f6e\u6587\u4ef6{}\u52a0\u8f7d\u6210\u529f", (Object)filePath);
        }
        catch (Exception e) {
            try {
                logger.error("\u5916\u7f6e\u914d\u7f6e\u6587\u4ef6" + filePath + "\u52a0\u8f7d\u5931\u8d25\uff01{}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                EnvPropertiesLoader.closeStream(input);
                throw throwable;
            }
            EnvPropertiesLoader.closeStream(input);
        }
        EnvPropertiesLoader.closeStream(input);
        return filePropOut;
    }

    private static void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Properties loadFile() {
        logger.info("<<<======\u5f00\u59cb\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6======>>>");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)EnvPropertiesLoader.loadLocalFile());
        if (properties.containsKey("app.name")) {
            String appName = properties.getProperty("app.name");
            DEFAULT_CONF_FILE = File.separator + "wls" + File.separator + "envconfig" + File.separator + appName + File.separator + DEFAULT_CONF_FILE_NAME;
        }
        properties.putAll((Map<?, ?>)EnvPropertiesLoader.loadOutFile(DEFAULT_CONF_FILE));
        properties.entrySet().forEach(value -> {
            logger.info(value.getKey().toString() + "=" + value.getValue().toString());
            EnvContextConfig.put(value.getKey().toString(), value.getValue().toString());
        });
        return properties;
    }
}

