package org.iartisan.runtime.support;


import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import org.iartisan.runtime.jdbc.MybatisBaseMapper;
import org.iartisan.runtime.utils.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;

/**
 * <p>
 * management service support
 *
 * @author King
 * @since 2017/6/22
 */
public class BaseManagementServiceSupport<M extends MybatisBaseMapper<?>, T> implements IBaseManagementService<T> {

    @Autowired
    protected M baseMapper;

    private Class doClass;

    public <U> Class<U> getDoClass() {
        if (doClass == null) {
            ParameterizedType type = (ParameterizedType) ((ParameterizedType) this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            doClass = (Class) type.getActualTypeArguments()[0];
        }
        return doClass;

    }


    @Override
    public void updateData(T t) {
        baseMapper.updateById(BeanUtil.copyBean(t, getDoClass()));
    }

    @Override
    public void deleteData(T t) {
        Class dbDel = BeanUtil.copyBean(t, getDoClass());
        Wrapper wrapper = new EntityWrapper(dbDel);
        baseMapper.delete(wrapper);
    }

    @Override
    public void saveData(T t) {
        baseMapper.insert(BeanUtil.copyBean(t, getDoClass()));
    }

    @Override
    public void deleteDataById(Serializable id) {
        baseMapper.deleteById(id);
    }

}
