package org.iartisan.runtime.web.controller;

import org.iartisan.runtime.web.authentication.RealmBean;
import org.iartisan.runtime.web.contants.WebConstants;
import org.iartisan.runtime.web.utils.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * <p>
 * base controller
 *
 * @author King
 * @since 2017/12/19
 */
public abstract class BaseController {

    protected final static String _data = "data";

    protected final static String _redirect = "redirect:";

    protected Logger logger = LoggerFactory.getLogger(getClass());

    protected String getCustId() {
        RealmBean realmBean = (RealmBean) WebUtil.getShiroSession().getAttribute(WebConstants._USER);
        if (null != realmBean) {
            return realmBean.getUserId();
        }
        return "";
    }

}
