/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.api.aspect;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.iartisan.runtime.api.base.BaseRes;
import org.iartisan.runtime.api.code.ResCodeEnum;
import org.iartisan.runtime.api.validator.ValidatorUtil;
import org.iartisan.runtime.env.EnvContextConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void doAspect() {
    }

    @Around(value="doAspect()")
    public Object around(ProceedingJoinPoint point) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Object object;
        long start = System.currentTimeMillis();
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        Class clazz = methodSignature.getReturnType();
        Object[] args = point.getArgs();
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                this.logger.info("{}{}.{}{}{}", new Object[]{"\n===[API-REQ]====>>>", targetMethod.getDeclaringClass().getName(), targetMethod.getName(), "\t>>>\t", arg.toString()});
            }
        }
        try {
            if (EnvContextConfig.get("api.validation", "on").toUpperCase().equals("ON")) {
                for (Object arg : args) {
                    ValidatorUtil.validate(arg);
                }
            }
            object = point.proceed();
            this.logger.info("{}{}.{}{}{}", new Object[]{"\n===[API-RES]====>>>", targetMethod.getDeclaringClass().getName(), targetMethod.getName(), "\t>>>\t", object.toString()});
            if (EnvContextConfig.get("performance.log", "OFF").toUpperCase().equals("ON")) {
                this.logger.info("===>\u63a5\u53e3{}.{}\u8017\u65f6:{}\u6beb\u79d2", new Object[]{targetMethod.getDeclaringClass().getName(), targetMethod.getName(), System.currentTimeMillis() - start});
            }
            return object;
        }
        catch (Throwable throwable) {
            this.logger.error("{}{}", new Object[]{targetMethod.getDeclaringClass().getName(), targetMethod.getName(), throwable});
            object = Class.forName(clazz.getName()).newInstance();
            BaseRes res = (BaseRes)object;
            if (throwable instanceof IllegalArgumentException) {
                res.setCode(ResCodeEnum.IllegalArgument.getCode());
                res.setMsg(throwable.getMessage());
            } else {
                res.setSystemErrorRes();
            }
            this.logger.info("{}{}.{}{}{}", new Object[]{"\n===[API-RES]====>>>", targetMethod.getDeclaringClass().getName(), targetMethod.getName(), "\t>>>\t", res.toString()});
            if (EnvContextConfig.get("performance.log", "OFF").equals("ON")) {
                this.logger.info("===>\u63a5\u53e3{}.{}\u8017\u65f6:{}\u6beb\u79d2", new Object[]{targetMethod.getDeclaringClass().getName(), targetMethod.getName(), System.currentTimeMillis() - start});
            }
            return res;
        }
    }
}

