/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.jdbc.annotations.Pagination;
import org.iartisan.runtime.jdbc.dialects.MySQLDialect;
import org.iartisan.runtime.utils.CollectionUtil;

@Deprecated
@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class})})
public class PaginationInterceptor
implements Interceptor {
    private MySQLDialect mySQLDialect = MySQLDialect.newInstance();
    private static final String SQL_BASE_COUNT = "SELECT COUNT(1) FROM ( %s ) TOTAL";

    public Object intercept(Invocation invocation) throws Throwable {
        String methodName;
        String mapperId;
        Class clazz;
        RoutingStatementHandler routingStatementHandler;
        MetaObject metaObject;
        MappedStatement mappedStatement;
        Object target = invocation.getTarget();
        if (target instanceof StatementHandler && (mappedStatement = (MappedStatement)(metaObject = MetaObject.forObject((Object)(routingStatementHandler = (RoutingStatementHandler)target), (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory())).getValue("delegate.mappedStatement")).getSqlCommandType().equals((Object)SqlCommandType.SELECT) && this.needPagination(clazz = this.refelectMapperClass(mapperId = mappedStatement.getId()), methodName = this.refelectMethodName(mapperId))) {
            Connection connection = (Connection)invocation.getArgs()[0];
            Object parameterObject = routingStatementHandler.getParameterHandler().getParameterObject();
            Page page = null;
            if (parameterObject instanceof Page) {
                page = (Page)parameterObject;
            } else if (parameterObject instanceof Map) {
                Map objectMap = (Map)parameterObject;
                page = (Page)objectMap.get("page");
            }
            if (null == page) {
                throw new IllegalArgumentException("\u5206\u9875\u65b9\u6cd5\u4e2d\u7f3a\u5c11\uff1aorg.iartisan.runtime.bean.Page \u5bf9\u8c61");
            }
            BoundSql boundSql = routingStatementHandler.getBoundSql();
            String querySQL = this.mySQLDialect.buildPaginationSQL(boundSql.getSql(), (page.getCurrPage() - 1) * page.getPageSize(), page.getPageSize());
            this.countTotal(mappedStatement, boundSql, page, connection);
            metaObject.setValue("delegate.boundSql.sql", (Object)querySQL);
            metaObject.setValue("delegate.rowBounds.offset", (Object)0);
            metaObject.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
        }
        return invocation.proceed();
    }

    private void countTotal(MappedStatement mappedStatement, BoundSql boundSql, Page page, Connection connection) throws SQLException, IllegalAccessException {
        PreparedStatement statement = connection.prepareStatement(String.format(SQL_BASE_COUNT, boundSql.getSql()));
        this.setParameters(mappedStatement, statement, boundSql);
        int total = 0;
        try (ResultSet resultSet = statement.executeQuery();){
            if (resultSet.next()) {
                total = resultSet.getInt(1);
            }
        }
        page.setTotalRecords(total);
    }

    private Field getAdditionalParametersField() {
        try {
            Field additionalParametersField = BoundSql.class.getDeclaredField("additionalParameters");
            additionalParametersField.setAccessible(true);
            return additionalParametersField;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public void setParameters(MappedStatement mappedStatement, PreparedStatement ps, BoundSql boundSql) throws SQLException, IllegalAccessException {
        Object parameterObject = boundSql.getParameterObject();
        TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        Configuration configuration = mappedStatement.getConfiguration();
        Map additionalParameters = null;
        additionalParameters = (Map)this.getAdditionalParametersField().get(boundSql);
        ErrorContext.instance().activity("setting parameters").object(mappedStatement.getParameterMap().getId());
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (parameterObject == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else {
                    MetaObject metaObject = configuration.newMetaObject(parameterObject);
                    value = metaObject.getValue(propertyName);
                    if (value == null && CollectionUtil.isNotEmpty(additionalParameters)) {
                        value = additionalParameters.get(propertyName);
                    }
                }
                TypeHandler typeHandler = parameterMapping.getTypeHandler();
                JdbcType jdbcType = parameterMapping.getJdbcType();
                if (value == null && jdbcType == null) {
                    jdbcType = configuration.getJdbcTypeForNull();
                }
                typeHandler.setParameter(ps, i + 1, value, jdbcType);
            }
        }
    }

    private Class refelectMapperClass(String sqlId) throws ClassNotFoundException {
        int mapperPosition = sqlId.lastIndexOf(".");
        Class<?> clazz = Class.forName(sqlId.substring(0, mapperPosition));
        return clazz;
    }

    private String refelectMethodName(String sqlId) {
        int mapperPosition = sqlId.lastIndexOf(".");
        String methodName = sqlId.substring(mapperPosition + 1);
        return methodName;
    }

    public boolean needPagination(Class clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            Pagination pagination = method.getAnnotation(Pagination.class);
            if (null == pagination) break;
            return true;
        }
        return false;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

