/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.utils;

import java.util.Date;
import org.iartisan.runtime.utils.DateUtils;

public class RelativeDateFormatUtil {
    private static final long ONE_JUST = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final String ONE_JUST_AGO = "\u521a\u521a";
    private static final String ONE_HOUR_AGO = "\u5c0f\u65f6\u524d";
    private static final String ONE_DAY_AGO = "\u5929\u524d";

    public static String format(String dateStr) {
        long delta = new Date().getTime() - DateUtils.toDate(dateStr).getTime();
        if (delta < 2700000L) {
            return ONE_JUST_AGO;
        }
        if (delta < 86400000L) {
            long hours = RelativeDateFormatUtil.toHours(delta);
            return (hours <= 0L ? 1L : hours) + ONE_HOUR_AGO;
        }
        if (delta < 172800000L) {
            return "\u6628\u5929";
        }
        if (delta < 2592000000L) {
            long days = RelativeDateFormatUtil.toDays(delta);
            return (days <= 0L ? 1L : days) + ONE_DAY_AGO;
        }
        return dateStr;
    }

    private static long toSeconds(long date) {
        return date / 1000L;
    }

    private static long toMinutes(long date) {
        return RelativeDateFormatUtil.toSeconds(date) / 60L;
    }

    private static long toHours(long date) {
        return RelativeDateFormatUtil.toMinutes(date) / 60L;
    }

    private static long toDays(long date) {
        return RelativeDateFormatUtil.toHours(date) / 24L;
    }

    private static long toMonths(long date) {
        return RelativeDateFormatUtil.toDays(date) / 30L;
    }
}

