package org.iartisan.runtime.api.validator;

import org.apache.commons.collections.CollectionUtils;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import java.util.Set;

/**
 * <p>
 * 接口验证
 *
 * @author King
 * @since 2016/11/21
 */
//@Service
public class ValidatorUtil {

    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public static <T> void validate(T obj) throws IllegalArgumentException {
        Set<ConstraintViolation<T>> violations = validator.validate(obj);
        if (CollectionUtils.isNotEmpty(violations)) {
            for (ConstraintViolation<T> constraintViolation : violations) {
                throw new IllegalArgumentException(constraintViolation.getMessage());
            }
        }
    }
}
