package org.iartisan.runtime.env;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


public class EnvContextConfig {

    private static Map<String,String> configHolder = new ConcurrentHashMap();

    public static String get(String key){
        return configHolder.get(key);
    }
    public static String get(String key,Object defaultVal){
        if(!configHolder.containsKey(key)){
            return ""+defaultVal;
        }
        return configHolder.get(key);
    }

    public static void put(String key,String val){
        if(val!=null){
            val = val.trim();
        }
        configHolder.put(key,val);
    }
    public static String remove(String key){
        return configHolder.remove(key);
    }

    public static String getAppName(){
        return get("app.name");
    }
    public static String getAppEnv(){
        return get("env");
    }
}
