package org.iartisan.runtime.env;

import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

import java.io.IOException;
import java.util.Properties;

/**
 * <p>
 * 外置env.properties文件加载
 *
 * @author King
 * @since 2017/6/13
 */
//@Order(1)
public class EnvPropertiesSourceLoader extends PropertiesPropertySourceLoader implements PropertySourceLoader {

    @Override
    public PropertySource<?> load(String name, Resource resource, String profile) throws IOException {
        if (profile == null) {
            Properties properties = PropertiesLoaderUtils.loadProperties(resource);
            Properties env = EnvPropertiesLoader.loadFile();
            env.entrySet().forEach(item -> properties.put(item.getKey(), item.getValue()));
            if (!properties.isEmpty()) {
                return new PropertiesPropertySource(name, properties);
            }
        }
        return null;
    }
}
