package org.iartisan.runtime.jdbc;

import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.baomidou.mybatisplus.spring.MybatisSqlSessionFactoryBean;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;
import java.util.Properties;

/**
 * <p>
 * mybatis durid 配置
 *
 * @author King
 * @since 2017/4/21
 */
//@Configuration    //该注解类似于spring配置文件
public class MyBatisConfig {

    @Autowired
    private Environment env;

    /**
     * 创建数据源
     */
    @Bean
    @Primary
    public DataSource getDataSource() throws Exception {
        Properties props = new Properties();
        props.put("driverClassName", env.getProperty("jdbc.driverClassName"));
        props.put("url", env.getProperty("jdbc.url"));
        props.put("username", env.getProperty("jdbc.username"));
        props.put("password", env.getProperty("jdbc.password"));
        return DruidDataSourceFactory.createDataSource(props);
    }

    /**
     * 根据数据源创建SqlSessionFactory
     */
    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource ds) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(ds);//指定数据源(这个必须有，否则报错)
        //下边两句仅仅用于*.xml文件，如果整个持久层操作不需要使用到xml文件的话（只用注解就可以搞定），则不加
        sessionFactoryBean.setTypeAliasesPackage(env.getProperty("mybatis.type-aliases-package"));//指定基包
        //配置文件位置
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        sessionFactoryBean.setConfigLocation(resourcePatternResolver.getResource(env.getProperty("mybatis.config-location")));
        sessionFactoryBean.setMapperLocations(resourcePatternResolver.getResources(env.getProperty("mybatis.mapper-locations")));//指定xml文件位置
        return sessionFactoryBean.getObject();
    }
}
