package org.iartisan.runtime.support;


import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.jdbc.MybatisBaseMapper;
import org.iartisan.runtime.jdbc.PageHelper;
import org.iartisan.runtime.utils.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;


/**
 * <p>
 * query service support
 *
 * @author King
 * @since 2017/6/22
 */
public class BaseQueryServiceSupport<M extends MybatisBaseMapper<?>, T> implements IBaseQueryService<T> {

    @Autowired
    protected M baseMapper;

    private Class tClass;

    private Logger logger = LoggerFactory.getLogger(getClass());

    private Class<T> getTClass() {
        if (tClass == null) {
            tClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[2];
        }
        return tClass;

    }

    private Class doClass;

    public <U> Class<U> getDoClass() {
        if (doClass == null) {
            ParameterizedType type = (ParameterizedType) ((ParameterizedType) this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            doClass = (Class) type.getActualTypeArguments()[0];
        }
        return doClass;

    }

    @Override
    public PageWrapper<T> getAllPageData(Page page) {
        try {
            PageWrapper result = PageHelper.getAllPageData(baseMapper, page);
            PageWrapper<T> paginationBean = new PageWrapper(result.getPage());
            paginationBean.setDataList(result.getDataList());
            return paginationBean;
        } catch (Exception e) {
            logger.error("getAllPageData Exception:", e);
        }
        return null;
    }

    @Override
    public PageWrapper<T> getPageData(Page page, T t) {
        try {
            PageWrapper result = PageHelper.getPageData(baseMapper, page, BeanUtil.copyBean(t, getDoClass()));
            PageWrapper<T> paginationBean = new PageWrapper(result.getPage());
            paginationBean.setDataList(result.getDataList());
            return paginationBean;
        } catch (Exception e) {
            logger.error("getAllPageData Exception:", e);
        }
        return null;
    }

    @Override
    public List<T> getAllData() {
        try {
            Wrapper wrapper = Condition.EMPTY;
            List dbResult = baseMapper.selectList(wrapper);
            return BeanUtil.copyList(dbResult, getTClass());
        } catch (Exception e) {
            logger.error("getAllList Exception:", e);
        }
        return null;
    }

    @Override
    public List<T> getListDataByObjs(T t) {
        Wrapper wrapper = new EntityWrapper(BeanUtil.copyBean(t, getDoClass()));
        List dbResult = baseMapper.selectList(wrapper);
        List<T> dataList = BeanUtil.copyList(dbResult, getTClass());
        return dataList;
    }

    @Override
    public T getDataById(Serializable id) {
        T obj = BeanUtil.copyBean(baseMapper.selectById(id), getTClass());
        return obj;
    }

    @Override
    public T getDataByObjs(T t) {
        return null;
    }
}
