package org.iartisan.runtime.utils;

import java.util.Date;

/**
 * <p>
 * 最近时间显示
 *
 * @author King
 * @since 2017/12/21
 */
public class RelativeDateFormatUtil {


    private static final long ONE_JUST = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;

    private static final String ONE_JUST_AGO = "刚刚";
    private static final String ONE_HOUR_AGO = "小时前";
    private static final String ONE_DAY_AGO = "天前";


    public static String format(String dateStr) {
        long delta = new Date().getTime() - DateUtils.toDate(dateStr).getTime();
        if (delta < 45L * ONE_JUST) {
           // long minutes = toMinutes(delta);
            return  ONE_JUST_AGO;
        }
        if (delta < 24L * ONE_HOUR) {
            long hours = toHours(delta);
            return (hours <= 0 ? 1 : hours) + ONE_HOUR_AGO;
        }
        if (delta < 48L * ONE_HOUR) {
            return "昨天";
        }
        if (delta < 30L * ONE_DAY) {
            long days = toDays(delta);
            return (days <= 0 ? 1 : days) + ONE_DAY_AGO;
        }
        return dateStr;
    }

    private static long toSeconds(long date) {
        return date / 1000L;
    }

    private static long toMinutes(long date) {
        return toSeconds(date) / 60L;
    }

    private static long toHours(long date) {
        return toMinutes(date) / 60L;
    }

    private static long toDays(long date) {
        return toHours(date) / 24L;
    }

    private static long toMonths(long date) {
        return toDays(date) / 30L;
    }

}
