package org.iartisan.runtime.web.config;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import org.iartisan.runtime.env.EnvContextConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

/**
 * <p>
 * 图片验证码生成
 *
 * @author King
 * @since 2017/12/25
 */
@Configuration
public class KaptchaConfig {


    private static final String KAPTCHA_BORDER = "kaptcha.border";

    private static final String KAPTCHA_TEXTPRODUCER_FONT_COLOR = "kaptcha.textproducer.font.color";

    private static final String KAPTCHA_TEXTPRODUCER_CHAR_SPACE = "kaptcha.textproducer.char.space";

    @Bean
    public DefaultKaptcha producer() {
        Properties properties = new Properties();
        properties.put(KAPTCHA_BORDER, EnvContextConfig.get(KAPTCHA_BORDER, "no"));
        properties.put(KAPTCHA_TEXTPRODUCER_FONT_COLOR, EnvContextConfig.get(KAPTCHA_TEXTPRODUCER_FONT_COLOR, "black"));
        properties.put(KAPTCHA_TEXTPRODUCER_CHAR_SPACE, EnvContextConfig.get(KAPTCHA_TEXTPRODUCER_CHAR_SPACE, "5"));
        Config config = new Config(properties);
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        defaultKaptcha.setConfig(config);
        return defaultKaptcha;
    }

}
