/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.iartisan.runtime.env.EnvContextConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvPropertiesLoader {
    private static Logger logger = LoggerFactory.getLogger((String)"env");
    private static String DEFAULT_CONF_FILE_NAME = "env.properties";
    private static String DEFAULT_CONF_FILE = File.separator + "wls" + File.separator + "envconfig" + File.separator + DEFAULT_CONF_FILE_NAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadLocalFile() {
        Properties filePropIn;
        block8: {
            filePropIn = new Properties();
            InputStream fis = null;
            InputStreamReader reader = null;
            try {
                fis = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_CONF_FILE_NAME);
                if (fis == null) {
                    ResourceBundle res = ResourceBundle.getBundle("env");
                    Set<String> keys = res.keySet();
                    for (String key : keys) {
                        filePropIn.put(key, new String(res.getString(key).getBytes("ISO-8859-1"), "GBK"));
                    }
                } else {
                    reader = new InputStreamReader(fis, "GBK");
                    filePropIn.load(reader);
                }
                EnvPropertiesLoader.closeReader(reader);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                break block8;
            }
            finally {
                EnvPropertiesLoader.closeReader(reader);
                EnvPropertiesLoader.closeStream(fis);
            }
            EnvPropertiesLoader.closeStream(fis);
        }
        return filePropIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadOutFile(String filePath) {
        Properties filePropOut = new Properties();
        FileInputStream fis = null;
        InputStreamReader reader = null;
        try {
            fis = new FileInputStream(filePath);
            reader = new InputStreamReader((InputStream)fis, "utf-8");
            filePropOut.load(reader);
            logger.info("\u5916\u7f6e\u914d\u7f6e\u6587\u4ef6{}\u52a0\u8f7d\u6210\u529f", (Object)filePath);
        }
        catch (Exception e) {
            try {
                logger.error("\u5916\u7f6e\u914d\u7f6e\u6587\u4ef6" + filePath + "\u52a0\u8f7d\u5931\u8d25\uff01{}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                EnvPropertiesLoader.closeReader(reader);
                EnvPropertiesLoader.closeStream(fis);
                throw throwable;
            }
            EnvPropertiesLoader.closeReader(reader);
            EnvPropertiesLoader.closeStream(fis);
        }
        EnvPropertiesLoader.closeReader(reader);
        EnvPropertiesLoader.closeStream(fis);
        return filePropOut;
    }

    private static void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void closeReader(InputStreamReader is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Properties loadFile() {
        logger.info("<<<======\u5f00\u59cb\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6======>>>");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)EnvPropertiesLoader.loadLocalFile());
        if (properties.containsKey("app.name")) {
            String appName = properties.getProperty("app.name");
            DEFAULT_CONF_FILE = File.separator + "wls" + File.separator + "envconfig" + File.separator + appName + File.separator + DEFAULT_CONF_FILE_NAME;
        }
        properties.putAll((Map<?, ?>)EnvPropertiesLoader.loadOutFile(DEFAULT_CONF_FILE));
        properties.entrySet().forEach(value -> {
            logger.info(value.getKey().toString() + "=" + value.getValue().toString());
            EnvContextConfig.put(value.getKey().toString(), value.getValue().toString());
        });
        return properties;
    }
}

