/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.jdbc;

import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.baomidou.mybatisplus.spring.MybatisSqlSessionFactoryBean;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MyBatisConfig {
    @Autowired
    private Environment env;

    @Bean
    @Primary
    public DataSource getDataSource() throws Exception {
        Properties props = new Properties();
        props.put("driverClassName", this.env.getProperty("jdbc.driverClassName"));
        props.put("url", this.env.getProperty("jdbc.url"));
        props.put("username", this.env.getProperty("jdbc.username"));
        props.put("password", this.env.getProperty("jdbc.password"));
        return DruidDataSourceFactory.createDataSource((Properties)props);
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource ds) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(ds);
        sessionFactoryBean.setTypeAliasesPackage(this.env.getProperty("mybatis.type-aliases-package"));
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        sessionFactoryBean.setConfigLocation(resourcePatternResolver.getResource(this.env.getProperty("mybatis.config-location")));
        sessionFactoryBean.setMapperLocations(resourcePatternResolver.getResources(this.env.getProperty("mybatis.mapper-locations")));
        return sessionFactoryBean.getObject();
    }
}

