package org.iartisan.runtime.api.base;

import org.iartisan.runtime.api.code.ResCodeEnum;

import java.io.Serializable;

/**
 * <p>
 * 基础返回
 *
 * @author King
 * @since 2017/12/8
 */
public class BaseRes implements Serializable {

    private String code;

    private String msg;

    /**
     * 默认成功
     */
    public BaseRes() {
        this.code = ResCodeEnum.succcess.getCode();
        this.msg = ResCodeEnum.succcess.getDesc();
    }

    public BaseRes(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setSystemErrorRes() {
        this.code = ResCodeEnum.system_error.getCode();
        this.msg = ResCodeEnum.system_error.getDesc();
    }

    public void setNotAllowedErrorRes() {
        this.code = ResCodeEnum.IllegalArgument.getCode();
        this.msg = ResCodeEnum.IllegalArgument.getDesc();
    }

    public void setNotAllowedErrorRes(String msg) {
        this.code = ResCodeEnum.IllegalArgument.getCode();
        this.msg = msg;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("BaseRes{");
        sb.append("code='").append(code).append('\'');
        sb.append(", msg='").append(msg).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
