package org.iartisan.runtime.utils;

import org.iartisan.runtime.bean.PageWrapper;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * @author King
 * @since 2017/7/7
 */
public class BeanUtil {
    public static <T> T copyBean(Object resource, Class<T> clazz) {
        try {
            T result = clazz.newInstance();
            BeanUtils.copyProperties(resource, result);
            return result;
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> List<T> copyList(List resource, Class<T> clazz) {
        List<T> result = new ArrayList<>();
        if (null != resource) {
            for (Object o : resource) {
                T t = copyBean(o, clazz);
                result.add(t);
            }
        }
        return result;
    }

    public static <T> PageWrapper<T> copyPage(PageWrapper<?> dbPageWrapper, Class<T> clazz) {
        PageWrapper<T> resPage = new PageWrapper<>(dbPageWrapper.getPage());
        if (null != dbPageWrapper) {
            List<T> dataList = BeanUtil.copyList(dbPageWrapper.getData(), clazz);
            resPage.setData(dataList);
        }
        return resPage;
    }
}
