package org.iartisan.runtime.support;

import com.baomidou.mybatisplus.mapper.Wrapper;
import org.iartisan.runtime.bean.Page;
import org.iartisan.runtime.bean.PageWrapper;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 通用服务
 *
 * @author King
 * @since 2017/6/22
 */
public interface IBaseQueryService<T> extends IBaseService {

    PageWrapper<T> getAllPageData(Page page);

    List<T> getAllData();

    List<T> getListDataByObjs(T t);

    List<T> getListDataByWrapper(Wrapper wrapper);

    PageWrapper<T> getPageData(Page page, T t);

    /**
     * wrapper 条件查询
     *
     * @param page
     * @param wrapper
     * @return
     */
    PageWrapper<T> getPageDataByWrapper(Page page, Wrapper wrapper);

    T getDataById(Serializable id);

    T getDataByObjs(T t);
}
