package org.iartisan.runtime.utils;

import org.iartisan.runtime.bean.PageWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * Bean Utils
 *
 * @author King
 * @since 2017/7/7
 */
public class BeanUtil {

    private static Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static <T> T copyBean(Object resource, Class<T> clazz) {
        try {
            if (null == resource) {
                return null;
            }
            T result = clazz.newInstance();
            BeanUtils.copyProperties(resource, result);
            return result;
        } catch (InstantiationException e) {
            e.printStackTrace();
            logger.error("copyBean InstantiationException:" + e);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
            logger.error("copyBean IllegalAccessException:" + e);
        }
        return null;
    }

    public static <T> List<T> copyList(List resource, Class<T> clazz) {
        if (null == resource) {
            return null;
        }
        List<T> result = new ArrayList<>();
        for (Object o : resource) {
            T t = copyBean(o, clazz);
            result.add(t);
        }
        return result;
    }

    public static <T> PageWrapper<T> copyPage(PageWrapper<?> resource, Class<T> clazz) {
        if (null == resource) {
            return null;
        }
        PageWrapper<T> resPage = new PageWrapper<>(resource.getPage());
        List<T> dataList = BeanUtil.copyList(resource.getData(), clazz);
        resPage.setData(dataList);
        return resPage;
    }
}
