/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.utils;

import java.util.ArrayList;
import java.util.List;
import org.iartisan.runtime.bean.PageWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BeanUtil {
    private static Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static <T> T copyBean(Object resource, Class<T> clazz) {
        try {
            if (null == resource) {
                return null;
            }
            T result = clazz.newInstance();
            BeanUtils.copyProperties((Object)resource, result);
            return result;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            logger.error("copyBean InstantiationException:" + e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            logger.error("copyBean IllegalAccessException:" + e);
        }
        return null;
    }

    public static <T> List<T> copyList(List resource, Class<T> clazz) {
        if (null == resource) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Object o : resource) {
            T t = BeanUtil.copyBean(o, clazz);
            result.add(t);
        }
        return result;
    }

    public static <T> PageWrapper<T> copyPage(PageWrapper<?> resource, Class<T> clazz) {
        if (null == resource) {
            return null;
        }
        PageWrapper<T> resPage = new PageWrapper<T>(resource.getPage());
        List<T> dataList = BeanUtil.copyList(resource.getData(), clazz);
        resPage.setData(dataList);
        return resPage;
    }
}

