/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.web.authentication;

import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.iartisan.runtime.env.EnvContextConfig;
import org.iartisan.runtime.exception.ApiRemoteException;
import org.iartisan.runtime.web.authentication.RealmBean;
import org.iartisan.runtime.web.utils.WebUtil;

public abstract class AuthenticationService
extends AuthorizingRealm {
    private static final String INCORRECTCREDENTIALS_MSG = "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef,\u8bf7\u91cd\u65b0\u767b\u5f55";

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        RealmBean realmBean = (RealmBean)principals.getPrimaryPrincipal();
        Set<String> permsSet = this.getPermissions(realmBean.getUserId());
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        info.setStringPermissions(permsSet);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String userName = (String)token.getPrincipal();
        String userPwd = new String((char[])token.getCredentials());
        try {
            RealmBean realmBean = this.getRealmBean(userName, userPwd);
            if (realmBean == null) {
                throw new IncorrectCredentialsException(EnvContextConfig.get("iartsian.authentication.fail.msg", INCORRECTCREDENTIALS_MSG));
            }
            WebUtil.getShiroSession().setAttribute((Object)"_user", (Object)realmBean);
            SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)realmBean, (Object)userPwd, this.getName());
            return info;
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage());
        }
    }

    protected abstract RealmBean getRealmBean(String var1, String var2) throws ApiRemoteException;

    protected abstract Set<String> getPermissions(String var1);
}

