package org.iartisan.runtime.properties

import java.util.concurrent.ConcurrentHashMap

/**
  * <p>
  *
  * @author King 
  * @since 2017/1/17
  */
object AppContextConfig {
  private val configHolder = new ConcurrentHashMap[String, String]

  def getConfigMap: java.util.Map[String, String] = configHolder

  def get(key: String): String = configHolder.get(key)

  def get(key: String, defaultVal: Any): String = {
    if (!configHolder.containsKey(key)) return "" + defaultVal
    configHolder.get(key)
  }

  def put(key: String, value: String) {
    if (value != null) {
      configHolder.put(key, value.trim)
    }
  }

  def remove(key: String): String = configHolder.remove(key)

  def getAppName: String = get("app.name")

  def getAppEnv: String = get("env")

}
