package org.iartisan.runtime.spring;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * spring 上下文
 *
 * @author King  2019/6/24
 */
public class SpringContext implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    public SpringContext() {
    }

    public static SpringContext getInstance() {
        return SpringContext.SpringContextInstance.INSTANCE;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public <T> T getBean(Class<T> clazz) {
        return this.applicationContext.getBean(clazz);
    }

    public <T> T getBean(String beanId) {
        return (T) this.applicationContext.getBean(beanId);
    }

    /**
     * 单例实现
     */
    private static class SpringContextInstance {
        private static final SpringContext INSTANCE = new SpringContext();

        private SpringContextInstance() {
        }
    }
}
