package org.iartisan.runtime.support;


import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.bean.Pagination;
import org.iartisan.runtime.jdbc.MybatisBaseMapper;
import org.iartisan.runtime.jdbc.PageHelper;
import org.iartisan.runtime.utils.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;


/**
 * <p>
 * query service support
 *
 * @author King
 * @since 2017/6/22
 */
public class BaseQueryServiceSupport<M extends MybatisBaseMapper<?>, T> implements IBaseQueryService<T> {

    @Autowired
    protected M baseMapper;

    private Class tClass;

    private Class<T> getTClass() {
        if (tClass == null) {
            tClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        }
        return tClass;

    }

    private Class doClass;

    private <U> Class<U> getDoClass() {
        if (doClass == null) {
            Class<?> result = (Class<?>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            doClass = (Class) ((ParameterizedType) result.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        }
        return doClass;
    }

    @Override
    public PageWrapper<T> getAllPageData(Pagination page) {
        try {
            PageWrapper result = PageHelper.getAllPageData(baseMapper, page);
            PageWrapper<T> paginationBean = new PageWrapper(result.getPage());
            paginationBean.setRows(BeanUtil.copyList(result.getRows(), getTClass()));
            return paginationBean;
        } catch (Exception e) {
            LOGGER.error("getAllPageData Exception:", e);
        }
        return null;
    }

    @Override
    public PageWrapper<T> getPageData(Pagination page, T t) {
        try {
            PageWrapper result = PageHelper.getPageData(baseMapper, page, BeanUtil.copyBean(t, getDoClass()));
            PageWrapper<T> paginationBean = new PageWrapper(result.getPage());
            paginationBean.setRows(BeanUtil.copyList(result.getRows(), getTClass()));
            return paginationBean;
        } catch (Exception e) {
            LOGGER.error("getPageData Exception:", e);
        }
        return null;
    }

    @Override
    public PageWrapper<T> getPageDataByWrapper(Pagination page, Wrapper wrapper) {
        try {
            PageWrapper result = PageHelper.getPageDataByWrapper(baseMapper, page, wrapper);
            PageWrapper<T> paginationBean = new PageWrapper(result.getPage());
            paginationBean.setRows(BeanUtil.copyList(result.getRows(), getTClass()));
            return paginationBean;
        } catch (Exception e) {
            LOGGER.error("getPageDataByWrapper Exception:", e);
        }
        return null;
    }

    @Override
    public List<T> getAllData() {
        try {
            List dbResult = baseMapper.selectList(Wrappers.emptyWrapper());
            return BeanUtil.copyList(dbResult, getTClass());
        } catch (Exception e) {
            LOGGER.error("getAllData Exception:", e);
        }
        return null;
    }

    @Override
    public List<T> getListDataByObjs(T t) {
        Wrapper wrapper = new QueryWrapper(BeanUtil.copyBean(t, getDoClass()));
        return getListDataByWrapper(wrapper);
    }

    @Override
    public List<T> getListDataByWrapper(Wrapper wrapper) {
        List dbResult = baseMapper.selectList(wrapper);
        List<T> dataList = BeanUtil.copyList(dbResult, getTClass());
        return dataList;
    }

    @Override
    public T getDataById(Serializable id) {
        T obj = BeanUtil.copyBean(baseMapper.selectById(id), getTClass());
        return obj;
    }

    @Override
    public T getDataByObjs(T t) {
        Wrapper wrapper = new QueryWrapper(BeanUtil.copyBean(t, getDoClass()));
        List dbResult = baseMapper.selectList(wrapper);
        if (null != dbResult && dbResult.size() > 0) {
            return BeanUtil.copyBean(dbResult.get(0), getTClass());
        }
        return null;
    }
}
