package org.iartisan.runtime.support;


import com.baomidou.mybatisplus.core.conditions.Wrapper;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.bean.Pagination;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 通用服务
 *
 * @author King
 * @since 2017/6/22
 */
public interface IBaseQueryService<T> extends IBaseService {

    /**
     * 查询所有分页数据
     * @param page
     * @return
     */
    PageWrapper<T> getAllPageData(Pagination page);

    /**
     * 查询所有数据
     * @return
     */
    List<T> getAllData();

    List<T> getListDataByObjs(T t);

    List<T> getListDataByWrapper(Wrapper wrapper);

    PageWrapper<T> getPageData(Pagination page, T t);

    /**
     * wrapper 条件查询
     *
     * @param page
     * @param wrapper
     * @return
     */
    PageWrapper<T> getPageDataByWrapper(Pagination page, Wrapper wrapper);

    T getDataById(Serializable id);

    T getDataByObjs(T t);
}
