package org.iartisan.runtime.web.utils;


import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * web帮助类
 *
 * @author King
 * @since 2017/4/27
 */
public class WebUtil {

    public static Session getShiroSession() {
        return getShiroSubject().getSession();
    }

    public static Subject getShiroSubject() {
        return SecurityUtils.getSubject();
    }

    public static HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }

}
